/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class LightedButton
extends PanelComponent
implements IConfigurableComponent {
    public int color = 0xFF0000;
    private boolean active;
    private boolean latching;
    @Nonnull
    private ControlPanelNetwork.RSChannel outputChannel = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    private int ticksTillOff;
    private static final float size = 0.0625f;

    LightedButton() {
        super("lighted_button");
    }

    public LightedButton(int color, boolean active, boolean latching, @Nonnull ControlPanelNetwork.RSChannel out) {
        this();
        this.color = color;
        this.active = active;
        this.latching = latching;
        this.outputChannel = out;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74768_a("color", this.color);
        if (!toItem) {
            nbt.func_74768_a("timeout", this.ticksTillOff);
            nbt.func_74757_a("active", this.active);
        }
        nbt.func_74757_a("latching", this.latching);
        nbt.func_74774_a("rsChannel", this.outputChannel.getColor());
        nbt.func_74768_a("rsId", this.outputChannel.getController());
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.color = nbt.func_74762_e("color");
        this.ticksTillOff = nbt.func_74762_e("timeout");
        this.active = nbt.func_74767_n("active");
        this.latching = nbt.func_74767_n("latching");
        byte rsOutputChannel = nbt.func_74771_c("rsChannel");
        int rsOutputId = nbt.func_74762_e("rsId");
        this.outputChannel = new ControlPanelNetwork.RSChannel(rsOutputId, rsOutputChannel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        float[] color = PanelUtils.getFloatColor(this.active, this.color);
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>(5);
        PanelUtils.addColoredBox(color, GRAY, null, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0625f, 0.03125f, 0.0625f), ret, false);
        if (this.active) {
            ((RawQuad)ret.get((int)0)).light = 1044735;
        }
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        LightedButton ret = new LightedButton(this.color, this.active, this.latching, this.outputChannel);
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.0625f), (double)this.getHeight(), (double)(this.y + 0.0625f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRel, EntityPlayerMP player) {
        if (!this.latching && this.active) {
            this.ticksTillOff = 10;
        } else {
            this.setOut(!this.active);
            if (!this.latching) {
                this.ticksTillOff = 10;
            }
        }
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
    }

    @Override
    public void update() {
        if (!this.latching && this.active) {
            --this.ticksTillOff;
            this.panel.func_70296_d();
            if (this.ticksTillOff <= 0) {
                this.setOut(false);
            }
        }
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        net.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.active ? 15 : 0)));
    }

    @Override
    public float getHeight() {
        return 0.03125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.renderInGUIDefault(gui, 0xFF000000 | this.color);
    }

    private void setOut(boolean on) {
        this.active = on;
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.active ? 15 : 0)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LightedButton that = (LightedButton)o;
        if (this.color != that.color) {
            return false;
        }
        if (this.active != that.active) {
            return false;
        }
        return this.latching == that.latching;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.color;
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.latching ? 1 : 0);
        return result;
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case BOOL: {
                if (id != 0) break;
                this.latching = ((NBTTagByte)value).func_150290_f() != 0;
                break;
            }
            case RS_CHANNEL: {
                if (id != 0) break;
                this.outputChannel = this.outputChannel.withColor(value);
                break;
            }
            case INT: {
                if (id != 0) break;
                this.outputChannel = this.outputChannel.withController(value);
                break;
            }
            case FLOAT: {
                this.color = PanelUtils.setColor(this.color, id, value);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.desc.latching", (Object[])new Object[0]);
            }
            case RS_CHANNEL: 
            case INT: {
                return null;
            }
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return "INVALID";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.desc.latching_info", (Object[])new Object[0]);
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)"industrialwires.desc.rschannel_info", (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)"industrialwires.desc.rsid_info", (Object[])new Object[0]);
            }
            case FLOAT: {
                return null;
            }
        }
        return "INVALID?";
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.outputChannel.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 50, this.outputChannel.getController(), 2, false)};
    }

    @Override
    public IConfigurableComponent.BoolConfig[] getBooleanOptions() {
        return new IConfigurableComponent.BoolConfig[]{new IConfigurableComponent.BoolConfig("latching", 0, 70, this.latching)};
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        int x = 70;
        int yOffset = 10;
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", x, yOffset, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", x, yOffset + 20, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", x, yOffset + 40, Float.valueOf(color[2]), 60)};
    }

    @Override
    public int getColor() {
        return this.color;
    }
}

