/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import malte0811.industrialwires.blocks.controlpanel.TileEntityGeneralCP;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ControlPanelNetwork {
    protected Map<RSChannel, List<ChangeListener>> listeners = new HashMap<RSChannel, List<ChangeListener>>();
    protected Map<RSChannel, List<OutputValue>> allOutputs = new HashMap<RSChannel, List<OutputValue>>();
    protected Map<RSChannel, OutputValue> activeOutputs = new HashMap<RSChannel, OutputValue>();
    protected Map<RSChannel, OutputValue> secondActiveOutputs = new HashMap<RSChannel, OutputValue>();
    protected Set<BlockPos> members = new HashSet<BlockPos>();

    public void addListener(IOwner owner, Consumer<RSChannelState> listener, RSChannel ... channels) {
        ChangeListener l = new ChangeListener(owner, listener);
        for (RSChannel channel : channels) {
            if (!channel.isValid()) continue;
            this.listeners.computeIfAbsent(channel, c -> new ArrayList()).add(l);
            if (this.activeOutputs.containsKey(channel)) {
                listener.accept(this.activeOutputs.get(channel).targetState);
                continue;
            }
            listener.accept(new RSChannelState(channel, 0));
        }
    }

    public void setOutputs(IOwner owner, RSChannelState ... out) {
        for (RSChannelState o : out) {
            if (!o.getChannel().isValid()) continue;
            if (this.removeForChannel(owner, this.allOutputs.get(o.getChannel()), null)) {
                this.allOutputs.remove(o.getChannel());
            }
            if (o.getStrength() > 0) {
                OutputValue outVal = new OutputValue(owner, o);
                this.allOutputs.computeIfAbsent(o.getChannel(), c -> new ArrayList()).add(outVal);
            }
            this.recalculateOutput(o.getChannel(), Collections.singleton(owner), Collections.emptyList());
        }
    }

    public void removeIOFor(IOwner owner) {
        Iterator<Map.Entry<RSChannel, List<ChangeListener>>> iteratorL = this.listeners.entrySet().iterator();
        while (iteratorL.hasNext()) {
            Map.Entry<RSChannel, List<ChangeListener>> entry = iteratorL.next();
            this.removeForChannel(owner, entry.getValue(), iteratorL);
        }
        Iterator<Map.Entry<RSChannel, List<OutputValue>>> iteratorO = this.allOutputs.entrySet().iterator();
        while (iteratorO.hasNext()) {
            Map.Entry<RSChannel, List<OutputValue>> entry = iteratorO.next();
            if (this.removeForChannel(owner, entry.getValue(), iteratorO)) continue;
            this.recalculateOutput(entry.getKey(), Collections.singleton(owner), Collections.emptyList());
        }
    }

    public void removeMember(BlockPos pos, World w) {
        for (List<ChangeListener> list : this.listeners.values()) {
            list.removeIf(l -> l.ownerAtPos(pos));
        }
        Iterator<Map.Entry<RSChannel, List<OutputValue>>> iterator = this.allOutputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RSChannel, List<OutputValue>> entry = iterator.next();
            entry.getValue().removeIf(l -> l.ownerAtPos(pos));
            if (entry.getValue().isEmpty()) {
                iterator.remove();
            }
            this.recalculateOutput(entry.getKey(), Collections.emptyList(), Collections.singleton(pos));
        }
        this.members.remove(pos);
        this.split(pos, w);
    }

    private void removeAllMembers(Collection<BlockPos> toRemove) {
        Iterator<Map.Entry<RSChannel, List<ChangeListener>>> iteratorL = this.listeners.entrySet().iterator();
        while (iteratorL.hasNext()) {
            Map.Entry<RSChannel, List<ChangeListener>> entry = iteratorL.next();
            entry.getValue().removeIf(l -> l.ownerAtPos(toRemove));
            if (!entry.getValue().isEmpty()) continue;
            iteratorL.remove();
        }
        Iterator<Map.Entry<RSChannel, List<OutputValue>>> iteratorO = this.allOutputs.entrySet().iterator();
        while (iteratorO.hasNext()) {
            Map.Entry<RSChannel, List<OutputValue>> entry = iteratorO.next();
            entry.getValue().removeIf(l -> l.ownerAtPos(toRemove));
            if (entry.getValue().isEmpty()) {
                iteratorO.remove();
            }
            this.recalculateOutput(entry.getKey(), Collections.emptyList(), toRemove);
        }
        this.members.removeAll(toRemove);
    }

    public void addMember(TileEntityGeneralCP member) {
        this.members.add(member.getBlockPos());
        member.setNetworkAndInit(this);
    }

    public void replaceWith(ControlPanelNetwork newNet, World w) {
        this.replaceWith(newNet, w, (Collection<BlockPos>)ImmutableSet.copyOf(this.members));
    }

    private void replaceWith(ControlPanelNetwork newNet, World w, Collection<BlockPos> toReplace) {
        this.removeAllMembers((Collection<BlockPos>)ImmutableList.copyOf(toReplace));
        for (BlockPos member : toReplace) {
            TileEntityGeneralCP te = MiscUtils.getLoadedTE(w, member, TileEntityGeneralCP.class);
            if (te == null) continue;
            newNet.addMember(te);
        }
    }

    private void recalculateOutput(RSChannel channel, Collection<IOwner> excluded, Collection<BlockPos> excludedPos) {
        List<ChangeListener> listenersForChannel;
        OutputValue oldMax = this.activeOutputs.get(channel);
        OutputValue oldSecMax = this.secondActiveOutputs.get(channel);
        OutputValue newMax = null;
        OutputValue newSecMax = null;
        if (this.allOutputs.containsKey(channel)) {
            for (OutputValue v : this.allOutputs.get(channel)) {
                if (v.isStrongerThan(newMax)) {
                    newSecMax = newMax;
                    newMax = v;
                    continue;
                }
                if (!v.isStrongerThan(newSecMax)) continue;
                newSecMax = v;
            }
        }
        if (newMax == null) {
            newSecMax = newMax = new OutputValue(null, new RSChannelState(channel, 0));
            this.activeOutputs.remove(channel);
        } else {
            this.activeOutputs.put(channel, newMax);
        }
        this.secondActiveOutputs.put(channel, newSecMax);
        if (newSecMax == null) {
            newSecMax = new OutputValue(null, new RSChannelState(channel, 0));
        }
        if (!(newSecMax.equals(oldSecMax) && newMax.equals(oldMax) || (listenersForChannel = this.listeners.get(channel)) == null)) {
            for (ChangeListener l : listenersForChannel) {
                if (l.isOwnedBy(excluded) || l.ownerAtPos(excludedPos)) continue;
                if (!l.hasSameOwner(newMax)) {
                    l.onChange(newMax.getTargetState());
                    continue;
                }
                l.onChange(newSecMax.getTargetState());
            }
        }
    }

    private <T extends Owned> boolean removeForChannel(IOwner owner, List<T> l, Iterator<?> it) {
        if (l == null) {
            return false;
        }
        l.removeIf(val -> val.isOwnedBy(owner));
        if (l.isEmpty()) {
            if (it != null) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    private <T extends Owned> boolean removeForChannel(BlockPos owner, List<T> l, Iterator<?> it) {
        l.removeIf(val -> val.ownerAtPos(owner));
        if (l.isEmpty()) {
            if (it != null) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    private void split(BlockPos pos, World w) {
        HashSet<BlockPos> reached = new HashSet<BlockPos>();
        List<BlockPos> newForThis = null;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            List<BlockPos> netForSide;
            BlockPos start = pos.func_177972_a(side);
            if (reached.contains(start) || (netForSide = MiscUtils.discoverLocal(start, (p, s) -> this.members.contains(p))).isEmpty()) continue;
            reached.addAll(netForSide);
            if (newForThis == null) {
                newForThis = netForSide;
                continue;
            }
            this.replaceWith(new ControlPanelNetwork(), w, netForSide);
        }
    }

    public static class RSChannelState {
        private final RSChannel channel;
        private final byte strength;

        public RSChannelState(RSChannel channel, byte strength) {
            this.channel = channel;
            this.strength = strength;
        }

        public byte getStrength() {
            return this.strength;
        }

        public RSChannel getChannel() {
            return this.channel;
        }

        public int getColor() {
            return this.getChannel().getColor();
        }

        public int getController() {
            return this.getChannel().getController();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RSChannelState that = (RSChannelState)o;
            if (this.strength != that.strength) {
                return false;
            }
            return this.channel.equals(that.channel);
        }

        public int hashCode() {
            int result = this.channel.hashCode();
            result = 31 * result + this.strength;
            return result;
        }
    }

    public static class RSChannel {
        public static final RSChannel INVALID_CHANNEL = new RSChannel(-1, 0);
        public static final RSChannel DEFAULT_CHANNEL = new RSChannel(0, 0);
        private final int controller;
        private final byte color;

        public RSChannel(int controller, byte color) {
            this.controller = controller;
            this.color = color;
        }

        public byte getColor() {
            return this.color;
        }

        public int getController() {
            return this.controller;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RSChannel rsChannel = (RSChannel)o;
            if (this.controller != rsChannel.controller) {
                return false;
            }
            return this.color == rsChannel.color;
        }

        public int hashCode() {
            int result = this.controller;
            result = 31 * result + this.color;
            return result;
        }

        public boolean isValid() {
            return this.controller >= 0 && this.color >= 0;
        }

        public RSChannel withController(int controller) {
            return new RSChannel(controller, this.color);
        }

        public RSChannel withColor(byte color) {
            return new RSChannel(this.controller, color);
        }

        public RSChannel withController(NBTBase nbt) {
            return this.withController(((NBTTagInt)nbt).func_150287_d());
        }

        public RSChannel withColor(NBTBase nbt) {
            return this.withColor(((NBTTagByte)nbt).func_150290_f());
        }
    }

    public static interface IOwner {
        public BlockPos getBlockPos();
    }

    private static class Owned {
        @Nullable
        private final IOwner owner;

        private Owned(@Nullable IOwner owner) {
            this.owner = owner;
        }

        public final boolean isOwnedBy(IOwner o) {
            return o.equals(this.owner);
        }

        public final boolean ownerAtPos(BlockPos o) {
            return o.equals((Object)this.getOwnerPos());
        }

        public final boolean isOwnedBy(Collection<IOwner> o) {
            return o.contains(this.owner);
        }

        public final boolean ownerAtPos(Collection<BlockPos> o) {
            return o.contains(this.getOwnerPos());
        }

        public final BlockPos getOwnerPos() {
            return this.owner == null ? BlockPos.field_177992_a : this.owner.getBlockPos();
        }

        public boolean hasSameOwner(Owned active) {
            return Objects.equals(this.owner, active.owner);
        }
    }

    protected static class OutputValue
    extends Owned {
        private final RSChannelState targetState;

        private OutputValue(@Nullable IOwner owner, RSChannelState targetState) {
            super(owner);
            this.targetState = targetState;
        }

        public RSChannelState getTargetState() {
            return this.targetState;
        }

        public boolean isStrongerThan(OutputValue other) {
            return other == null || this.targetState.getStrength() > other.getTargetState().getStrength();
        }
    }

    protected static class ChangeListener
    extends Owned {
        private final Consumer<RSChannelState> listener;

        private ChangeListener(IOwner owner, Consumer<RSChannelState> listener) {
            super(owner);
            this.listener = listener;
        }

        public void onChange(RSChannelState newState) {
            this.listener.accept(newState);
        }
    }
}

