/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.tweakers;

import com.google.common.collect.Maps;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.util.Map;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootTableWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootTables")
@Mod.EventBusSubscriber(modid="loottweaker")
public class LootTableTweaker {
    private static Map<ResourceLocation, ZenLootTableWrapper> tweakedTableStorage = Maps.newHashMap();
    private static boolean tableLoadingStarted = false;

    @ZenMethod
    public static ZenLootTableWrapper getTable(String tableName) {
        ResourceLocation tableLoc = new ResourceLocation(tableName);
        if (!tweakedTableStorage.containsKey(tableLoc)) {
            tweakedTableStorage.put(tableLoc, new ZenLootTableWrapper(new LootTable(LootUtils.NO_POOLS), tableLoc));
        }
        return tweakedTableStorage.get(tableLoc);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTableLoad(LootTableLoadEvent event) {
        LootTableTweaker.applyTweaks(event.getName(), event.getTable());
        if (!tableLoadingStarted) {
            tableLoadingStarted = true;
            LootTableTweaker.onTableLoadingStarted();
        }
    }

    private static void onTableLoadingStarted() {
        for (Map.Entry<ResourceLocation, ZenLootTableWrapper> entry : tweakedTableStorage.entrySet()) {
            if (LootTableList.func_186374_a().contains(entry.getKey())) continue;
            CraftTweakerAPI.logError((String)String.format("No loot table with name %s exists!", entry.getKey()));
        }
    }

    private static void applyTweaks(ResourceLocation tableName, LootTable table) {
        if (table.isFrozen()) {
            return;
        }
        if (tweakedTableStorage.containsKey(tableName)) {
            tweakedTableStorage.get(tableName).applyLootTweaks(table);
        }
    }
}

