/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common;

import crafttweaker.CraftTweakerAPI;
import java.util.HashSet;
import java.util.Set;
import leviathan143.loottweaker.common.LTConfig;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stanhebben.zenscript.annotations.ZenClass;

@Mod.EventBusSubscriber(modid="loottweaker")
public class DeprecationWarningManager {
    private static final String WARNING = "%s is deprecated";
    private static final Set<String> deprecatedObjectsUsed = new HashSet<String>();
    private static int warnings = 0;

    public static void addWarning() {
        if (!LTConfig.deprecationWarnings) {
            return;
        }
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement caller = stackTrace[2];
            Class<?> clazz = Class.forName(caller.getClassName());
            ZenClass zenClass = clazz.getAnnotation(ZenClass.class);
            String zenName = zenClass.value();
            deprecatedObjectsUsed.add(zenName + "." + caller.getMethodName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void printDeprecationWarnings() {
        if (deprecatedObjectsUsed.isEmpty() || !LTConfig.deprecationWarnings) {
            return;
        }
        warnings = 0;
        CraftTweakerAPI.logWarning((String)"LootTweaker: One or more scripts use deprecated methods. Check crafttweaker.log for more information.");
        for (String deprecatedObj : deprecatedObjectsUsed) {
            CraftTweakerAPI.logInfo((String)String.format(WARNING, deprecatedObj));
        }
        CraftTweakerAPI.logInfo((String)"Refer to https://github.com/Leviathan143/LootTweaker/wiki/Deprecations for more info. This warning can be disabled in the config");
    }

    @SubscribeEvent
    public static void fixChatSpam(ClientChatReceivedEvent e) {
        if (e.getMessage().func_150254_d().contains("LootTweaker") && ++warnings > 1) {
            e.setCanceled(true);
        }
    }
}

