/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="jumping")
public class RitualJumping
extends Ritual {
    public static final String JUMP_RANGE = "jumpRange";

    public RitualJumping() {
        super("ritualJump", 0, 5000, "ritual.bloodmagic.jumpRitual");
        this.addBlockRange(JUMP_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3, 1, 3));
        this.setMaximumVolumeAndDistanceOfRange(JUMP_RANGE, 0, 5, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor jumpRange = this.getBlockRange(JUMP_RANGE);
        List entities = world.func_72872_a(EntityLivingBase.class, jumpRange.getAABB(masterRitualStone.getBlockPos()));
        for (EntityLivingBase entity : entities) {
            if (totalEffects >= maxEffects) break;
            double motionY = 1.5;
            entity.field_70143_R = 0.0f;
            if (entity.func_70093_af()) continue;
            entity.field_70181_x = motionY;
            ++totalEffects;
            if (!(entity instanceof EntityPlayer)) continue;
            Utils.setPlayerSpeedFromServer((EntityPlayer)entity, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int i = -1; i <= 1; ++i) {
            this.addCornerRunes(components, 1, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualJumping();
    }
}

