/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@RitualRegister(value="crystal_split")
public class RitualCrystalSplit
extends Ritual {
    public RitualCrystalSplit() {
        super("ritualCrystalSplit", 0, 20000, "ritual.bloodmagic.crystalSplitRitual");
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        EnumFacing direction = masterRitualStone.getDirection();
        BlockPos rawPos = pos.func_177981_b(2);
        TileEntity tile = world.func_175625_s(rawPos);
        if (!(tile instanceof TileDemonCrystal) || ((TileDemonCrystal)tile).getType() != EnumDemonWillType.DEFAULT) {
            return;
        }
        IBlockState rawState = world.func_180495_p(rawPos);
        TileDemonCrystal rawTile = (TileDemonCrystal)tile;
        if (rawTile.crystalCount >= 5) {
            BlockPos vengefulPos = pos.func_177972_a(this.rotateFacing(EnumFacing.NORTH, direction)).func_177984_a();
            BlockPos corrosivePos = pos.func_177972_a(this.rotateFacing(EnumFacing.EAST, direction)).func_177984_a();
            BlockPos steadfastPos = pos.func_177972_a(this.rotateFacing(EnumFacing.SOUTH, direction)).func_177984_a();
            BlockPos destructivePos = pos.func_177972_a(this.rotateFacing(EnumFacing.WEST, direction)).func_177984_a();
            int vengefulCrystals = 0;
            int corrosiveCrystals = 0;
            int steadfastCrystals = 0;
            int destructiveCrystals = 0;
            tile = world.func_175625_s(vengefulPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getType() == EnumDemonWillType.VENGEFUL && ((TileDemonCrystal)tile).crystalCount < 7) {
                vengefulCrystals = ((TileDemonCrystal)tile).crystalCount;
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(vengefulPos)) {
                return;
            }
            tile = world.func_175625_s(corrosivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getType() == EnumDemonWillType.CORROSIVE && ((TileDemonCrystal)tile).crystalCount < 7) {
                corrosiveCrystals = ((TileDemonCrystal)tile).crystalCount;
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(corrosivePos)) {
                return;
            }
            tile = world.func_175625_s(steadfastPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getType() == EnumDemonWillType.STEADFAST && ((TileDemonCrystal)tile).crystalCount < 7) {
                steadfastCrystals = ((TileDemonCrystal)tile).crystalCount;
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(steadfastPos)) {
                return;
            }
            tile = world.func_175625_s(destructivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getType() == EnumDemonWillType.DESTRUCTIVE && ((TileDemonCrystal)tile).crystalCount < 7) {
                destructiveCrystals = ((TileDemonCrystal)tile).crystalCount;
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(destructivePos)) {
                return;
            }
            rawTile.crystalCount -= 4;
            this.growCrystal(world, vengefulPos, EnumDemonWillType.VENGEFUL, vengefulCrystals);
            this.growCrystal(world, corrosivePos, EnumDemonWillType.CORROSIVE, corrosiveCrystals);
            this.growCrystal(world, steadfastPos, EnumDemonWillType.STEADFAST, steadfastCrystals);
            this.growCrystal(world, destructivePos, EnumDemonWillType.DESTRUCTIVE, destructiveCrystals);
            rawTile.func_70296_d();
            world.func_184138_a(rawPos, rawState, rawState, 3);
        }
    }

    public EnumFacing rotateFacing(EnumFacing facing, EnumFacing rotation) {
        switch (rotation) {
            case EAST: {
                return facing.func_176746_e();
            }
            case SOUTH: {
                return facing.func_176746_e().func_176746_e();
            }
            case WEST: {
                return facing.func_176735_f();
            }
        }
        return facing;
    }

    public void growCrystal(World world, BlockPos pos, EnumDemonWillType type, int currentCrystalCount) {
        if (currentCrystalCount <= 0) {
            world.func_180501_a(pos, RegistrarBloodMagicBlocks.DEMON_CRYSTAL.func_176203_a(type.ordinal()), 3);
        } else {
            TileDemonCrystal tile = (TileDemonCrystal)world.func_175625_s(pos);
            ++tile.crystalCount;
            tile.func_70296_d();
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 1000;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -1, EnumRuneType.FIRE);
        this.addRune(components, 1, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, 1, EnumRuneType.WATER);
        this.addRune(components, -1, 0, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrystalSplit();
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getUnlocalizedName() + ".info", new Object[0])};
    }
}

