/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.potion;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.event.SacrificeKnifeUsedEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class PotionEventHandlers {
    public static List<EntityPlayer> flightList = new ArrayList<EntityPlayer>();

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.BOOST)) {
            int i = event.getEntityLiving().func_70660_b(RegistrarBloodMagic.BOOST).func_76458_c();
            event.getEntityLiving().field_70181_x += (double)(0.1f * (float)(2 + i));
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!player.field_70170_p.field_72995_K) {
                if (player.func_70644_a(RegistrarBloodMagic.FLIGHT)) {
                    if (!player.func_175149_v() && !player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                        player.func_71016_p();
                        flightList.add(player);
                    }
                } else if (flightList.contains(player)) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                    flightList.remove(player);
                }
            }
        }
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.WHIRLWIND)) {
            int d0 = 3;
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(event.getEntityLiving().field_70165_t - 0.5, event.getEntityLiving().field_70163_u - 0.5, event.getEntityLiving().field_70161_v - 0.5, event.getEntityLiving().field_70165_t + 0.5, event.getEntityLiving().field_70163_u + 0.5, event.getEntityLiving().field_70161_v + 0.5).func_72321_a((double)d0, (double)d0, (double)d0);
            List entityList = event.getEntityLiving().func_130014_f_().func_72872_a(Entity.class, axisAlignedBB);
            for (Entity projectile : entityList) {
                if (projectile == null || !(projectile instanceof IProjectile)) continue;
                Entity throwingEntity = null;
                if (projectile instanceof EntityArrow) {
                    throwingEntity = ((EntityArrow)projectile).field_70250_c;
                } else if (projectile instanceof EntityThrowable) {
                    throwingEntity = ((EntityThrowable)projectile).func_85052_h();
                }
                if (throwingEntity != null && throwingEntity.equals((Object)event.getEntityLiving())) continue;
                double delX = projectile.field_70165_t - event.getEntityLiving().field_70165_t;
                double delY = projectile.field_70163_u - event.getEntityLiving().field_70163_u;
                double delZ = projectile.field_70161_v - event.getEntityLiving().field_70161_v;
                double angle = (delX * projectile.field_70159_w + delY * projectile.field_70181_x + delZ * projectile.field_70179_y) / (Math.sqrt(delX * delX + delY * delY + delZ * delZ) * Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y));
                if ((angle = Math.acos(angle)) < 2.356194490192345) continue;
                if (throwingEntity != null) {
                    delX = -projectile.field_70165_t + throwingEntity.field_70165_t;
                    delY = -projectile.field_70163_u + (throwingEntity.field_70163_u + (double)throwingEntity.func_70047_e());
                    delZ = -projectile.field_70161_v + throwingEntity.field_70161_v;
                }
                double curVel = Math.sqrt(delX * delX + delY * delY + delZ * delZ);
                double newVel = Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y);
                projectile.field_70159_w = newVel * (delX /= curVel);
                projectile.field_70181_x = newVel * (delY /= curVel);
                projectile.field_70179_y = newVel * (delZ /= curVel);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getEntityPlayer().func_70690_d(new PotionEffect(RegistrarBloodMagic.SOUL_FRAY, 400));
        }
    }

    @SubscribeEvent
    public static void onSacrificeKnifeUsed(SacrificeKnifeUsedEvent event) {
        if (event.player.func_70644_a(RegistrarBloodMagic.SOUL_FRAY)) {
            event.lpAdded = (int)((double)event.lpAdded * 0.1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDamageEvent(LivingAttackEvent event) {
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.WHIRLWIND) && event.isCancelable() && event.getSource().func_76352_a()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEndermanTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.PLANAR_BINDING) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }
}

