/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compress;

import WayofTime.bloodmagic.compress.CompressionRegistry;
import WayofTime.bloodmagic.util.BMLog;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class StorageBlockCraftingManager {
    private static final StorageBlockCraftingManager instance = new StorageBlockCraftingManager();
    private List<IRecipe> recipes = new LinkedList<IRecipe>();

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addStorageBlockRecipes() {
        BMLog.DEBUG.info("Total number of compression recipes: " + this.recipes.size(), new Object[0]);
    }

    public ItemStack findMatchingRecipe(InventoryCrafting craftingInventory, World world) {
        return this.findMatchingRecipe(craftingInventory, world, this.recipes);
    }

    private ItemStack findMatchingRecipe(InventoryCrafting craftingInventory, World world, List<IRecipe> list) {
        int j;
        int i = 0;
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack itemstack1 = ItemStack.field_190927_a;
        for (j = 0; j < craftingInventory.func_70302_i_(); ++j) {
            ItemStack itemstack2 = craftingInventory.func_70301_a(j);
            if (itemstack2.func_190926_b()) continue;
            if (i == 0) {
                itemstack = itemstack2;
            }
            if (i == 1) {
                itemstack1 = itemstack2;
            }
            ++i;
        }
        if (i == 2 && itemstack.func_77973_b() == itemstack1.func_77973_b() && itemstack.func_190916_E() == 1 && itemstack1.func_190916_E() == 1 && itemstack.func_77973_b().isRepairable()) {
            Item item = itemstack.func_77973_b();
            int j1 = item.getMaxDamage(itemstack) - itemstack.func_77952_i();
            int k = item.getMaxDamage(itemstack) - itemstack1.func_77952_i();
            int l = j1 + k + item.getMaxDamage(itemstack) * 5 / 100;
            int i1 = item.getMaxDamage(itemstack) - l;
            if (i1 < 0) {
                i1 = 0;
            }
            return new ItemStack(itemstack.func_77973_b(), 1, i1);
        }
        for (j = 0; j < list.size(); ++j) {
            IRecipe irecipe = list.get(j);
            if (!irecipe.func_77569_a(craftingInventory, world)) continue;
            return irecipe.func_77572_b(craftingInventory);
        }
        return ItemStack.field_190927_a;
    }

    public static StorageBlockCraftingManager getInstance() {
        return instance;
    }

    private static boolean isResultStackReversible(ItemStack stack, int gridSize, World world, List<IRecipe> list) {
        if (stack.func_190926_b()) {
            return false;
        }
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 2, 2);
        inventory.func_70299_a(0, stack);
        ItemStack returnStack = StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world, list);
        if (returnStack.func_190926_b()) {
            return false;
        }
        ItemStack compressedStack = ItemStack.field_190927_a;
        switch (gridSize) {
            case 2: {
                compressedStack = StorageBlockCraftingManager.get22Recipe(returnStack, world, list);
                break;
            }
            case 3: {
                compressedStack = StorageBlockCraftingManager.get33Recipe(returnStack, world, list);
            }
        }
        return !compressedStack.func_190926_b() && CompressionRegistry.areItemStacksEqual(stack, compressedStack);
    }

    private static ItemStack getRecipe(ItemStack stack, World world, int gridSize, List<IRecipe> list) {
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, gridSize, gridSize);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, stack);
        }
        return StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world, list);
    }

    private static boolean has22Recipe(ItemStack stack, World world, List<IRecipe> list) {
        return !StorageBlockCraftingManager.get22Recipe(stack, world, list).func_190926_b();
    }

    private static ItemStack get22Recipe(ItemStack stack, World world, List<IRecipe> list) {
        return StorageBlockCraftingManager.getRecipe(stack, world, 2, list);
    }

    private static boolean has33Recipe(ItemStack stack, World world, List<IRecipe> list) {
        return !StorageBlockCraftingManager.get33Recipe(stack, world, list).func_190926_b();
    }

    private static ItemStack get33Recipe(ItemStack stack, World world, List<IRecipe> list) {
        return StorageBlockCraftingManager.getRecipe(stack, world, 3, list);
    }
}

