/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.armor;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.ModelDraconicArmor;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.items.armor.WyvernArmor;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.Collection;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DraconicArmor
extends WyvernArmor {
    private static ItemArmor.ArmorMaterial draconicMaterial = EnumHelper.addArmorMaterial((String)"draconicArmor", (String)"draconicevolution:draconic_armor", (int)-1, (int[])new int[]{3, 6, 8, 3}, (int)20, (SoundEvent)SoundEvents.field_187716_o, (float)3.0f);
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model_invisible;

    public DraconicArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(draconicMaterial, renderIndexIn, equipmentSlotIn);
        this.baseProtectionPoints = 512.0f;
        this.baseRecovery = 4.0f;
    }

    public DraconicArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.baseProtectionPoints = 512.0f;
        this.baseRecovery = 4.0f;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        int i;
        int u;
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            registry.register(stack, new BooleanConfigField("armorNV", false, "config.field.armorNV.description"));
            registry.register(stack, new BooleanConfigField("armorNVLock", false, "config.field.armorNVLock.description"));
            registry.register(stack, new BooleanConfigField("armorAutoFeed", false, "config.field.armorAutoFeed.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            registry.register(stack, new IntegerConfigField("armorFSpeedModifier", 0, 0, MathHelper.clip((int)(DEConfig.flightSpeedLimit != -1 ? DEConfig.flightSpeedLimit : 600), (int)0, (int)1200), "config.field.armorFSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorInertiaCancel", false, "config.field.armorInertiaCancel.description"));
            registry.register(stack, new BooleanConfigField("armorFlightLock", false, "config.field.armorFlightLock.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            u = UpgradeHelper.getUpgradeLevel(stack, "moveSpeed");
            i = 200 + 100 * u + Math.max(u - 1, 0) * 100 + Math.max(u - 2, 0) * 100;
            registry.register(stack, new IntegerConfigField("armorSpeedModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorSpeedFOVWarp", false, "config.field.armorSpeedFOVWarp.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            u = UpgradeHelper.getUpgradeLevel(stack, "jumpBoost");
            i = 200 + 100 * u + Math.max(u - 1, 0) * 100 + Math.max(u - 2, 0) * 100;
            registry.register(stack, new IntegerConfigField("armorJumpModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorHillStep", true, "config.field.armorHillStep.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET || this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.CHEST) {
            registry.register(stack, new BooleanConfigField("sprintBoost", false, "config.field.sprintBoost.description"));
        }
        registry.register(stack, new BooleanConfigField("hideArmor", false, "config.field.hideArmor.description"));
        return registry;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (ToolConfigHelper.getBooleanField("hideArmor", itemStack)) {
            if (this.model_invisible == null) {
                this.model_invisible = new ModelBiped(){

                    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                    }
                };
            }
            return this.model_invisible;
        }
        if (DEConfig.disable3DModels) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
        }
        if (this.model == null) {
            this.model = this.field_77881_a == EntityEquipmentSlot.HEAD ? new ModelDraconicArmor(1.0f, true, false, false, false) : (this.field_77881_a == EntityEquipmentSlot.CHEST ? new ModelDraconicArmor(1.0f, false, true, false, false) : (this.field_77881_a == EntityEquipmentSlot.LEGS ? new ModelDraconicArmor(1.0f, false, false, true, false) : new ModelDraconicArmor(1.0f, false, false, false, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
            this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
            boolean bl = this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_184218_aH();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
        this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
        this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        return this.model;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() == DEFeatures.draconicHelm) {
            Potion nv;
            IItemHandler handler;
            if (world.field_72995_K) {
                return;
            }
            if (this.getEnergyStored(stack) >= 5000 && this.clearNegativeEffects((Entity)player)) {
                this.modifyEnergy(stack, -5000);
            }
            FoodStats foodStats = player.func_71024_bL();
            if (player.field_70173_aa % 100 == 0 && ToolConfigHelper.getBooleanField("armorAutoFeed", stack) && foodStats.func_75121_c() && this.getEnergyStored(stack) >= 500 && (handler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemFood food;
                    int amount;
                    ItemStack candidate = handler.getStackInSlot(i);
                    if (candidate.func_190926_b() || !(candidate.func_77973_b() instanceof ItemFood) || (amount = (food = (ItemFood)candidate.func_77973_b()).func_150905_g(candidate)) <= 0 || food.func_150905_g(candidate) + foodStats.func_75116_a() > 20) continue;
                    ItemStack foodStack = handler.extractItem(i, (candidate = candidate.func_77946_l()).func_190916_E(), false);
                    if (ItemStack.func_77989_b((ItemStack)foodStack, (ItemStack)candidate)) {
                        foodStats.func_151686_a(food, foodStack);
                        foodStack = food.func_77654_b(foodStack, world, (EntityLivingBase)player);
                        if (world.field_73012_v.nextInt(3) == 0) {
                            DelayedTask.run((int)20, () -> world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f));
                        }
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.5f + 0.5f * (float)world.field_73012_v.nextInt(2), (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        foodStack = handler.insertItem(i, foodStack, false);
                        this.modifyEnergy(stack, -500);
                        if (foodStack.func_190926_b()) break;
                        InventoryUtils.givePlayerStack((EntityPlayer)player, (ItemStack)foodStack.func_77946_l());
                        break;
                    }
                    if ((foodStack = handler.insertItem(i, foodStack, false)).func_190926_b()) continue;
                    InventoryUtils.givePlayerStack((EntityPlayer)player, (ItemStack)foodStack.func_77946_l());
                }
            }
            if ((nv = Potion.func_180142_b((String)"night_vision")) == null) {
                return;
            }
            PotionEffect active = player.func_70660_b(nv);
            if (ToolConfigHelper.getBooleanField("armorNV", stack) && (player.field_70170_p.func_175724_o(new BlockPos((int)Math.floor(player.field_70165_t), (int)player.field_70163_u + 1, (int)Math.floor(player.field_70161_v))) < 0.1f || ToolConfigHelper.getBooleanField("armorNVLock", stack))) {
                player.func_70690_d(new PotionEffect(nv, 500, 0, false, false));
            } else if (active != null && ToolConfigHelper.getBooleanField("armorNVLock", stack)) {
                player.func_184589_d(nv);
            }
        }
        super.onArmorTick(world, player, stack);
    }

    public boolean clearNegativeEffects(Entity par3Entity) {
        boolean flag = false;
        if (par3Entity.field_70173_aa % 20 == 0 && par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            for (PotionEffect potion : potions) {
                if (!potion.func_188419_a().func_76398_f() || potion.func_188419_a() == MobEffects.field_76419_f && ModHelper.isHoldingCleaver(player)) continue;
                player.func_184589_d(potion.func_188419_a());
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return ToolConfigHelper.getBooleanField("armorHillStep", stack);
    }

    @Override
    public float getFireResistance(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{true, ToolConfigHelper.getBooleanField("armorFlightLock", stack), ToolConfigHelper.getBooleanField("armorInertiaCancel", stack)};
    }

    @Override
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        int value = ToolConfigHelper.getIntegerField("armorFSpeedModifier", stack);
        if (DEConfig.flightSpeedLimit > -1 && value > DEConfig.flightSpeedLimit) {
            value = DEConfig.flightSpeedLimit;
        }
        float modifier = (float)value / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !BrandonsCore.proxy.isSprintKeyDown()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        float modifier = (float)ToolConfigHelper.getIntegerField("armorVFSpeedModifier", stack) / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !BrandonsCore.proxy.isSprintKeyDown()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public int getEnergyPerProtectionPoint() {
        return 1000;
    }

    @Override
    protected int getCapacity(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        if (level == 0) {
            return ToolStats.DRACONIC_BASE_CAPACITY;
        }
        return ToolStats.DRACONIC_BASE_CAPACITY * (int)Math.pow(2.0, level + 1);
    }

    @Override
    protected int getMaxReceive(ItemStack stack) {
        return 1000000;
    }
}

