/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontPixels;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

@Deprecated
public class GlyphMetrics {
    private int left = -1;
    private int right = -1;
    private int glyphHigh = 0;
    private int glyphLow = 0;

    public GlyphMetrics(char ch, Font font, int fontRes) {
        this.computeGlyphMetricsExactly(ch, font, fontRes);
    }

    public void computeGlyphMetricsExactly(char ch, Font font, int fontRes) {
        int pixel;
        int y;
        int x;
        if (ch == '.') {
            boolean bl = false;
        }
        BufferedImage image = new BufferedImage(fontRes, fontRes * 2, 6);
        Graphics2D g2 = image.createGraphics();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        FontPixels fp = new FontPixels(font, fm, false, false);
        float baseY = (float)fp.getAscent() * 1.5f;
        if (fontRes >= 24) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        float leftMargin = (fontRes - fm.charWidth(ch)) / 2;
        if (fontRes >= 100) {
            g2.drawString(String.valueOf(ch), leftMargin, baseY);
        } else {
            g2.drawString(String.valueOf(ch), (int)leftMargin, Math.round(baseY));
        }
        for (x = 0; x < fontRes; ++x) {
            for (y = 0; y < fontRes * 2; ++y) {
                pixel = image.getRGB(x, y);
                if ((pixel & 0xFFFFFF) == 0) continue;
                this.left = x;
                break;
            }
            if (this.left != -1) break;
        }
        for (x = fontRes - 1; x >= 0; --x) {
            for (y = fontRes * 2 - 1; y >= 0; --y) {
                pixel = image.getRGB(x, y);
                if ((pixel & 0xFFFFFF) == 0) continue;
                this.right = x;
                break;
            }
            if (this.right != -1) break;
        }
        g2.dispose();
        if (this.left != -1 && this.right != -1) {
            this.glyphHigh = (int)((float)this.left * 16.0f / (float)fontRes) & 0xF;
            this.glyphLow = (int)((float)this.right * 16.0f / (float)fontRes) & 0xF;
        }
    }

    public int getRight() {
        return this.right;
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.getRight() - this.getLeft() + 1;
    }

    public int getGlyphHigh() {
        return this.glyphHigh;
    }

    public int getGlyphLow() {
        return this.glyphLow;
    }
}

