/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles;

import QuantumStorage.client.AdvancedGui;
import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.init.ModBlocks;
import QuantumStorage.inventory.DsuInventoryHandler;
import QuantumStorage.inventory.slot.SlotOutputItemHandler;
import QuantumStorage.tiles.AdvancedTileEntity;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornCraftingHelper;

public class TileQuantumStorageUnit
extends AdvancedTileEntity
implements ITickable {
    int STORAGE = 0;
    int INPUT = 1;
    int OUTPUT = 2;
    public static final DecimalFormat QUANTITY_FORMATTER = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));

    public TileQuantumStorageUnit() {
        this.inv = new DsuInventoryHandler();
    }

    public void func_73660_a() {
        try {
            if (!this.inv.getStackInSlot(this.INPUT).func_190926_b()) {
                if (this.inv.getStackInSlot(this.STORAGE).func_190926_b()) {
                    this.inv.setStackInSlot(this.STORAGE, this.inv.getStackInSlot(this.INPUT).func_77946_l());
                    this.inv.setStackInSlot(this.INPUT, ItemStack.field_190927_a);
                } else if (!this.inv.getStackInSlot(this.STORAGE).func_190926_b() && ItemUtils.isItemEqual((ItemStack)this.inv.getStackInSlot(this.INPUT), (ItemStack)this.inv.getStackInSlot(this.STORAGE), (boolean)true, (boolean)true)) {
                    this.inv.getStackInSlot(this.STORAGE).func_190917_f(this.inv.getStackInSlot(this.INPUT).func_190916_E());
                    this.inv.setStackInSlot(this.INPUT, ItemStack.field_190927_a);
                }
            }
            if (!this.inv.getStackInSlot(this.STORAGE).func_190926_b()) {
                int size = this.inv.getStackInSlot(this.STORAGE).func_77976_d();
                if (this.inv.getStackInSlot(this.OUTPUT) == ItemStack.field_190927_a || this.inv.getStackInSlot(this.OUTPUT).func_190916_E() == 0) {
                    if (this.inv.getStackInSlot(this.STORAGE).func_190916_E() >= size) {
                        this.inv.setStackInSlot(this.OUTPUT, this.inv.getStackInSlot(this.STORAGE).func_77946_l());
                        this.inv.getStackInSlot(this.OUTPUT).func_190920_e(size);
                        this.inv.getStackInSlot(this.STORAGE).func_190918_g(size);
                    } else {
                        this.inv.setStackInSlot(this.OUTPUT, this.inv.getStackInSlot(this.STORAGE));
                        this.inv.setStackInSlot(this.STORAGE, ItemStack.field_190927_a);
                    }
                }
                if (this.inv.getStackInSlot(this.STORAGE).func_190916_E() != 0 && ItemUtils.isItemEqual((ItemStack)this.inv.getStackInSlot(this.STORAGE), (ItemStack)this.inv.getStackInSlot(this.OUTPUT), (boolean)true, (boolean)true) && this.inv.getStackInSlot(this.OUTPUT).func_190916_E() <= size - 1) {
                    this.inv.getStackInSlot(this.OUTPUT).func_190917_f(1);
                    this.inv.getStackInSlot(this.STORAGE).func_190918_g(1);
                }
            }
            this.handleUpgrades();
            this.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sync();
    }

    @Override
    public String getName() {
        return "quantum_storage_unit";
    }

    @Override
    public List<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new SlotItemHandler((IItemHandler)this.inv, 1, 80, 20));
        slots.add((Slot)new SlotOutputItemHandler((IItemHandler)this.inv, 2, 80, 70));
        return slots;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileQuantumStorageUnit();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, (AdvancedTileEntity)worldIn.func_175625_s(pos));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY, GuiContainer gui, int guiLeft, int guiTop) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY, gui, guiLeft, guiTop);
        if (this.getInv().getStackInSlot(this.STORAGE) != ItemStack.field_190927_a && this.getInv().getStackInSlot(this.OUTPUT) != null) {
            this.getBuilder().drawBigBlueBar((AdvancedGui)gui, 31, 43, this.getInv().getStackInSlot(this.STORAGE).func_190916_E() + this.getInv().getStackInSlot(this.OUTPUT).func_190916_E(), Integer.MAX_VALUE, mouseX - guiLeft, mouseY - guiTop, "Stored", this.getInv().getStackInSlot(this.OUTPUT).func_82833_r(), TileQuantumStorageUnit.formatQuantity(this.getInv().getStackInSlot(this.STORAGE).func_190916_E() + this.getInv().getStackInSlot(this.OUTPUT).func_190916_E()));
        }
        if (this.getInv().getStackInSlot(this.STORAGE) == ItemStack.field_190927_a && this.getInv().getStackInSlot(this.OUTPUT) != ItemStack.field_190927_a) {
            this.getBuilder().drawBigBlueBar((AdvancedGui)gui, 31, 43, this.getInv().getStackInSlot(this.OUTPUT).func_190916_E(), Integer.MAX_VALUE, mouseX - guiLeft, mouseY - guiTop, "Stored", this.getInv().getStackInSlot(this.OUTPUT).func_82833_r(), TileQuantumStorageUnit.formatQuantity(this.getInv().getStackInSlot(this.STORAGE).func_190916_E() + this.getInv().getStackInSlot(this.OUTPUT).func_190916_E()));
        }
    }

    public static String formatQuantity(int qty) {
        if (qty >= 1000000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000000.0f) + "M";
        }
        if (qty >= 1000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000.0f) + "K";
        }
        return String.valueOf(qty);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inv.deserializeNBT(compound);
    }

    @Override
    public Block getBlock() {
        return ModBlocks.DSU;
    }

    @Override
    public void addRecipe() {
        if (!ConfigQuantumStorage.disableQuantumStorageUnit) {
            RebornCraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DSU), (Object[])new Object[]{"OOO", "ICI", "III", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z), Character.valueOf('C'), new ItemStack(ModBlocks.CHEST_DIAMOND)});
            RebornCraftingHelper.addShapelessRecipe((ItemStack)new ItemStack(ModBlocks.DSU), (Object[])new Object[]{new ItemStack(ModBlocks.DSU)});
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_179237_a(this.inv.serializeNBT());
        return compound;
    }

    @Override
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        return super.getCapability(capability, facing);
    }

    public void handleUpgrades() {
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74775_l("tileEntity") != null) {
            NBTTagList tagList = stack.func_77978_p().func_74775_l("tileEntity").func_150295_c("Items", 10);
            ItemStack stack1 = ItemStack.field_190927_a;
            NBTTagCompound itemTags = tagList.func_150305_b(0);
            NBTTagCompound itemTags2 = tagList.func_150305_b(2);
            int count = itemTags.func_74762_e("SizeSpecial") + itemTags2.func_74762_e("SizeSpecial");
            stack1 = new ItemStack(itemTags);
            stack1.func_190920_e(count);
            if (!stack1.func_190926_b()) {
                tooltip.add(TextFormatting.GOLD + "Stored Item Type: " + stack1.func_190916_E() + " " + stack1.func_82833_r());
            }
        }
    }
}

