/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.teamislands;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.teamislands.Island;
import com.feed_the_beast.teamislands.TeamIslands;
import com.feed_the_beast.teamislands.TeamIslandsConfig;
import com.feed_the_beast.teamislands.TeamIslandsTeamData;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="teamislands")
public class TeamIslandsUniverseData {
    public static TeamIslandsUniverseData INSTANCE;
    public final Universe universe;
    private final Island lobby;
    public final List<Island> islands;
    public Template islandTemplate;
    public BlockPos relativeSpawn;

    public TeamIslandsUniverseData(Universe u, NBTTagCompound nbt) {
        this.universe = u;
        this.lobby = new Island(this, 0, 0, 0, "server");
        this.lobby.spawned = true;
        this.islands = new ArrayList<Island>();
        this.islands.add(this.lobby);
        NBTTagList islandsTag = nbt.func_150295_c("Islands", 10);
        for (int i = 0; i < islandsTag.func_74745_c(); ++i) {
            this.islands.add(new Island(this, i + 1, islandsTag.func_150305_b(i)));
        }
        if (TeamIslandsConfig.islands.custom_structure_file.trim().isEmpty()) {
            this.islandTemplate = this.universe.world.func_72860_G().func_186340_h().func_186237_a(this.universe.server, new ResourceLocation("teamislands", "teamislands_island"));
        } else {
            ResourceLocation id = new ResourceLocation("teamislands", "teamislands_custom");
            this.islandTemplate = this.universe.world.func_72860_G().func_186340_h().func_189942_b(this.universe.server, id);
            if (this.islandTemplate == null) {
                this.islandTemplate = this.universe.world.func_72860_G().func_186340_h().func_186237_a(this.universe.server, id);
                File file = new File(Loader.instance().getConfigDir(), TeamIslandsConfig.islands.custom_structure_file.trim());
                if (file.exists() && file.isFile()) {
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        Object object = null;
                        try {
                            this.islandTemplate.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)fis));
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (fis != null) {
                                if (object != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    fis.close();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        int sx = this.islandTemplate.func_186259_a().func_177958_n() / 2;
        int sy = this.islandTemplate.func_186259_a().func_177956_o();
        int sz = this.islandTemplate.func_186259_a().func_177952_p() / 2;
        for (Map.Entry entry : this.islandTemplate.func_186258_a(BlockPos.field_177992_a, new PlacementSettings()).entrySet()) {
            if (!((String)entry.getValue()).equals("SPAWN_POINT")) continue;
            sx = ((BlockPos)entry.getKey()).func_177958_n();
            sy = ((BlockPos)entry.getKey()).func_177956_o();
            sz = ((BlockPos)entry.getKey()).func_177952_p();
        }
        this.relativeSpawn = new BlockPos(sx, sy, sz);
        if (FTBLibConfig.debugging.print_more_info) {
            TeamIslands.LOGGER.info("Island relative spawnpoint: " + this.relativeSpawn);
        }
    }

    public Island getIsland(int id) {
        Island island;
        if (id == 0) {
            return this.lobby;
        }
        Island island2 = island = id < 0 || id >= this.islands.size() ? null : this.islands.get(id);
        if (island == null) {
            ChunkPos pos = MathUtils.getSpiralPoint((int)(id + 1));
            island = new Island(this, this.islands.size(), pos.field_77276_a, pos.field_77275_b, "server");
            this.islands.add(island);
            this.universe.markDirty();
        }
        return island;
    }

    public Island getIsland(@Nullable ForgeTeam team) {
        if (team == null) {
            return this.lobby;
        }
        return ((TeamIslandsTeamData)team.getData().get("teamislands")).getIsland();
    }

    @SubscribeEvent
    public static void onUniverseLoaded(UniverseLoadedEvent.Pre event) {
        INSTANCE = new TeamIslandsUniverseData(event.getUniverse(), event.getData("teamislands"));
    }

    @SubscribeEvent
    public static void onUniverseSaved(UniverseSavedEvent event) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList islands = new NBTTagList();
        for (Island island : TeamIslandsUniverseData.INSTANCE.islands) {
            if (island.isLobby()) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            island.writeToNBT(nbt1);
            islands.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("Islands", (NBTBase)islands);
        event.setData("teamislands", nbt);
    }

    @SubscribeEvent
    public static void onUniverseUnloaded(UniverseClosedEvent event) {
        INSTANCE = null;
    }
}

