/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartP2PFluids
extends PartP2PTunnel<PartP2PFluids>
implements IFluidHandler {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private static final ThreadLocal<Deque<PartP2PFluids>> DEPTH = new ThreadLocal();
    private static final FluidTankProperties[] ACTIVE_TANK = new FluidTankProperties[]{new FluidTankProperties(null, 10000, true, false)};
    private static final FluidTankProperties[] INACTIVE_TANK = new FluidTankProperties[]{new FluidTankProperties(null, 0, false, false)};
    private IFluidHandler cachedTank;
    private int tmpUsed;

    public PartP2PFluids(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
        this.cachedTank = null;
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        PartP2PFluids in;
        this.cachedTank = null;
        if (this.isOutput() && (in = (PartP2PFluids)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capabilityClass) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capabilityClass);
    }

    @Override
    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public IFluidTankProperties[] getTankProperties() {
        PartP2PFluids tun;
        if (!this.isOutput() && (tun = (PartP2PFluids)this.getInput()) != null) {
            return ACTIVE_TANK;
        }
        return INACTIVE_TANK;
    }

    public int fill(FluidStack resource, boolean doFill) {
        Deque<PartP2PFluids> stack = this.getDepth();
        for (PartP2PFluids t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<PartP2PFluids> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<PartP2PFluids> i = list.iterator();
        while (i.hasNext()) {
            PartP2PFluids l = i.next();
            IFluidHandler tank = l.getTarget();
            l.tmpUsed = tank != null ? tank.fill(resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (!doFill) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return Math.min(resource.amount, requestTotal);
        }
        int available = resource.amount;
        i = list.iterator();
        int used = 0;
        while (i.hasNext() && available > 0) {
            IFluidHandler tank;
            PartP2PFluids l = i.next();
            FluidStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > available) {
                insert.amount = available;
            }
            l.tmpUsed = (tank = l.getTarget()) != null ? tank.fill(insert.copy(), true) : 0;
            available -= insert.amount;
            used += l.tmpUsed;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return used;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    private Deque<PartP2PFluids> getDepth() {
        Deque<PartP2PFluids> s = DEPTH.get();
        if (s == null) {
            s = new ArrayDeque<PartP2PFluids>();
            DEPTH.set(s);
        }
        return s;
    }

    private List<PartP2PFluids> getOutputs(Fluid input) {
        ArrayList<PartP2PFluids> outs = new ArrayList<PartP2PFluids>();
        try {
            for (PartP2PFluids l : this.getOutputs()) {
                IFluidHandler handler = l.getTarget();
                if (handler == null) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private IFluidHandler getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            this.cachedTank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
            return this.cachedTank;
        }
        return null;
    }
}

