/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.multipart;

import java.util.Optional;
import java.util.function.Function;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mcmultipart.api.world.IMultipartWorld;
import mcmultipart.slot.SlotRegistry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.PacketByteBuf;
import sonar.core.network.PacketByteBufMultipart;
import sonar.core.network.PacketMultipartSync;
import sonar.core.network.PacketTileSync;
import sonar.core.network.PacketTileSyncUpdate;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.network.utils.IByteBufTile;

public class SonarMultipartHelper {
    public static Optional<IMultipart> getMultipart(IBlockAccess world, BlockPos pos, IPartSlot slot, Function<IMultipart, Boolean> valid) {
        Optional multipart = MultipartHelper.getPart((IBlockAccess)world, (BlockPos)pos, (IPartSlot)slot);
        return multipart.isPresent() && valid.apply((IMultipart)multipart.get()) != false ? multipart : Optional.empty();
    }

    public static Optional<IMultipartTile> getMultipartTile(IBlockAccess world, BlockPos pos, IPartSlot slot, Function<IMultipartTile, Boolean> valid) {
        Optional multipart = MultipartHelper.getPartTile((IBlockAccess)world, (BlockPos)pos, (IPartSlot)slot);
        return multipart.isPresent() && valid.apply((IMultipartTile)multipart.get()) != false ? multipart : Optional.empty();
    }

    public static Optional<IMultipartTile> getMultipartTileFromSlotID(IBlockAccess world, BlockPos pos, int id) {
        return SonarMultipartHelper.getMultipartTile(world, pos, SlotRegistry.INSTANCE.getSlotFromID(id), part -> true);
    }

    public static World unwrapWorld(World world) {
        if (world instanceof IMultipartWorld) {
            return ((IMultipartWorld)world).getActualWorld();
        }
        return world;
    }

    public static IBlockAccess unwrapBlockAccess(IBlockAccess world) {
        if (world instanceof IMultipartBlockAccess) {
            return ((IMultipartBlockAccess)world).getActualWorld();
        }
        return world;
    }

    public static Object getTile(World world, BlockPos pos) {
        Optional container;
        if (SonarLoader.mcmultipartLoaded && (container = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos)).isPresent()) {
            return container;
        }
        return world.func_175625_s(pos);
    }

    public static boolean sendMultipartSyncToPlayer(TileSonarMultipart part, EntityPlayerMP player) {
        NBTTagCompound tag;
        if (part != null && part.func_145831_w() != null && !part.func_145831_w().field_72995_K && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendTo(SonarMultipartHelper.buildSyncPacket(part, tag, NBTHelper.SyncType.SYNC_OVERRIDE), player);
            return true;
        }
        return false;
    }

    public static boolean sendMultipartSyncAround(TileSonarMultipart part, int spread) {
        NBTTagCompound tag;
        if (part != null && part.func_145831_w() != null && !part.func_145831_w().field_72995_K && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendToAllAround(SonarMultipartHelper.buildSyncPacket(part, tag, NBTHelper.SyncType.SYNC_OVERRIDE), new NetworkRegistry.TargetPoint(part.func_145831_w().field_73011_w.getDimension(), (double)part.func_174877_v().func_177958_n(), (double)part.func_174877_v().func_177956_o(), (double)part.func_174877_v().func_177952_p(), (double)spread));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartUpdateSyncAround(TileSonarMultipart part, int spread) {
        NBTTagCompound tag;
        if (part != null && part.func_145831_w() != null && !part.func_145831_w().field_72995_K && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendToAllAround(SonarMultipartHelper.buildSyncPacketUpdate(part, tag, NBTHelper.SyncType.SYNC_OVERRIDE), new NetworkRegistry.TargetPoint(part.func_145831_w().field_73011_w.getDimension(), (double)part.func_174877_v().func_177958_n(), (double)part.func_174877_v().func_177956_o(), (double)part.func_174877_v().func_177952_p(), (double)spread));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartSyncToServer(TileSonarMultipart part) {
        NBTTagCompound tag;
        if (part != null && part.func_145831_w() != null && part.func_145831_w().field_72995_K && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendToServer(SonarMultipartHelper.buildSyncPacket(part, tag, NBTHelper.SyncType.SYNC_OVERRIDE));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartPacketAround(TileSonarMultipart part, int id, int spread) {
        if (part != null && !part.func_145831_w().field_72995_K && part instanceof IByteBufTile) {
            SonarCore.network.sendToAllAround(SonarMultipartHelper.buildBufPacket(part, id), new NetworkRegistry.TargetPoint(part.func_145831_w().field_73011_w.getDimension(), (double)part.func_174877_v().func_177958_n(), (double)part.func_174877_v().func_177956_o(), (double)part.func_174877_v().func_177952_p(), (double)spread));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartPacketToServer(TileSonarMultipart part, int id) {
        if (part != null && part.func_145831_w().field_72995_K && part instanceof IByteBufTile) {
            SonarCore.network.sendToServer(SonarMultipartHelper.buildBufPacket(part, id));
            return true;
        }
        return false;
    }

    public static IMessage buildRequestSyncPacket(TileSonarMultipart part, NBTTagCompound tag, NBTHelper.SyncType type) {
        int slotID = part.getSlotID();
        if (slotID == -1) {
            return new PacketTileSync(part.func_174877_v(), tag, type);
        }
        return new PacketMultipartSync(part.func_174877_v(), tag, type, slotID);
    }

    public static IMessage buildSyncPacketUpdate(TileSonarMultipart part, NBTTagCompound tag, NBTHelper.SyncType type) {
        int slotID = part.getSlotID();
        if (slotID == -1) {
            return new PacketTileSyncUpdate(part.func_174877_v(), tag, type);
        }
        return new PacketMultipartSync(part.func_174877_v(), tag, type, slotID);
    }

    public static IMessage buildSyncPacket(TileSonarMultipart part, NBTTagCompound tag, NBTHelper.SyncType type) {
        int slotID = part.getSlotID();
        if (slotID == -1) {
            return new PacketTileSync(part.func_174877_v(), tag, type);
        }
        return new PacketMultipartSync(part.func_174877_v(), tag, type, slotID);
    }

    public static IMessage buildBufPacket(TileSonarMultipart part, int id) {
        int slotID = part.getSlotID();
        if (slotID == -1) {
            return new PacketByteBuf((IByteBufTile)((Object)part), part.func_174877_v(), id, new ByteBufWritable[0]);
        }
        return new PacketByteBufMultipart(slotID, (IByteBufTile)((Object)part), part.func_174877_v(), id);
    }
}

