/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render;

import com.elytradev.architecture.client.proxy.ClientProxy;
import com.elytradev.architecture.client.render.ICustomRenderer;
import com.elytradev.architecture.client.render.target.RenderTargetBaked;
import com.elytradev.architecture.client.render.target.RenderTargetWorld;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.commons.lang3.reflect.FieldUtils;

public class CustomBlockDispatcher
extends BlockRendererDispatcher {
    protected BlockRendererDispatcher base;

    public CustomBlockDispatcher(BlockRendererDispatcher base) {
        super(base.func_175023_a(), Minecraft.func_71410_x().func_184125_al());
        this.base = base;
    }

    public static void inject() {
        BlockRendererDispatcher baseDispatcher = Minecraft.func_71410_x().func_175602_ab();
        CustomBlockDispatcher customBlockDispatcher = new CustomBlockDispatcher(Minecraft.func_71410_x().func_175602_ab());
        for (Field field : FieldUtils.getAllFields(BlockRendererDispatcher.class)) {
            try {
                field.setAccessible(true);
                FieldUtils.writeField((Field)field, (Object)((Object)customBlockDispatcher), (Object)FieldUtils.readField((Field)field, (Object)baseDispatcher));
            }
            catch (Exception e) {
                ArchitectureLog.error("Failed to transfer field from original render dispatcher to normal. {}", field);
            }
        }
        Accessor<CustomBlockDispatcher> mcBlockRenderDispatcher = Accessors.findField(Minecraft.class, "blockRenderDispatcher", "field_175618_aM");
        mcBlockRenderDispatcher.set(Minecraft.func_71410_x(), customBlockDispatcher);
    }

    public BlockModelShapes func_175023_a() {
        return this.base.func_175023_a();
    }

    public BlockModelRenderer func_175019_b() {
        return this.base.func_175019_b();
    }

    public IBakedModel func_184389_a(IBlockState state) {
        return this.base.func_184389_a(state);
    }

    public void func_175016_a(IBlockState state, float brightness) {
        this.base.func_175016_a(state, brightness);
    }

    public void func_175020_a(IBlockState state, BlockPos pos, TextureAtlasSprite icon, IBlockAccess world) {
        ICustomRenderer rend = ClientProxy.RENDERING_MANAGER.getCustomRenderer(world, pos, state);
        if (rend != null) {
            RenderTargetBaked target = new RenderTargetBaked(pos, icon);
            Trans3 t = Trans3.blockCenter;
            Block block = state.func_177230_c();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!block.canRenderInLayer(state, layer)) continue;
                rend.renderBlock(world, pos, state, target, layer, t);
            }
            IBakedModel model = target.getBakedModel();
            BufferBuilder tess = Tessellator.func_178181_a().func_178180_c();
            this.func_175019_b().func_178267_a(world, model, state, pos, tess, false);
        } else {
            this.base.func_175020_a(state, pos, icon, world);
        }
    }

    public boolean func_175018_a(IBlockState state, BlockPos pos, IBlockAccess world, BufferBuilder tess) {
        ICustomRenderer rend = ClientProxy.RENDERING_MANAGER.getCustomRenderer(world, pos, state);
        if (rend != null) {
            return this.customRenderBlockToWorld(world, pos, state, tess, null, rend);
        }
        return this.base.func_175018_a(state, pos, world, tess);
    }

    protected boolean customRenderBlockToWorld(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder tess, TextureAtlasSprite icon, ICustomRenderer rend) {
        RenderTargetWorld target = new RenderTargetWorld(world, pos, tess, icon);
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        rend.renderBlock(world, pos, state, target, layer, Trans3.blockCenter(pos));
        return target.end();
    }
}

