/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private static final int NORMAL_MODE = 0;
    private static final int TRANSMUTATION_MODE = 1;
    private static final double WALL_MODE = Math.sin(Math.toRadians(45.0));

    public MercurialEye() {
        super("mercurial_eye", 4, new String[]{"Normal", "Transmutation"});
        this.setNoRepair();
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound prevCapNBT) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            private final IItemHandler inv = new ItemStackHandler(2);

            public NBTTagCompound serializeNBT() {
                NBTTagCompound ret = new NBTTagCompound();
                ret.func_74782_a("Items", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null));
                return ret;
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, (NBTBase)nbt.func_150295_c("Items", 10));
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
                }
                return null;
            }
        };
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            IItemHandler inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inventory.getStackInSlot(0).func_190926_b() || inventory.getStackInSlot(1).func_190926_b()) {
                return EnumActionResult.FAIL;
            }
            if (!(inventory.getStackInSlot(0).func_77973_b() instanceof IItemEmc)) {
                return EnumActionResult.FAIL;
            }
            IBlockState newState = ItemHelper.stackToState(inventory.getStackInSlot(1));
            if (newState == null || newState.func_177230_c() == Blocks.field_150350_a) {
                return EnumActionResult.FAIL;
            }
            double kleinEmc = ((IItemEmc)inventory.getStackInSlot(0).func_77973_b()).getStoredEmc(inventory.getStackInSlot(0));
            long reqEmc = EMCHelper.getEmcValue(inventory.getStackInSlot(1));
            int charge = this.getCharge(stack);
            byte mode = this.getMode(stack);
            Vec3d look = player.func_70040_Z();
            int dX = 0;
            int dY = 0;
            int dZ = 0;
            boolean lookingDown = look.field_72448_b >= -1.0 && look.field_72448_b <= -WALL_MODE;
            boolean lookingUp = look.field_72448_b <= 1.0 && look.field_72448_b >= WALL_MODE;
            boolean lookingAlongZ = player.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z;
            AxisAlignedBB box = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            switch (facing) {
                case UP: {
                    if (lookingDown || mode == 1) {
                        box = box.func_72321_a((double)(charge * 2), 0.0, (double)(charge * 2)).func_72317_d((double)(-charge), 0.0, (double)(-charge));
                        dY = 1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72321_a((double)(charge * 2), (double)(charge * 2), 0.0).func_72317_d((double)(-charge), 1.0, 0.0);
                        break;
                    }
                    box = box.func_72321_a(0.0, (double)(charge * 2), (double)(charge * 2)).func_72317_d(0.0, 1.0, (double)(-charge));
                    break;
                }
                case DOWN: {
                    if (lookingUp || mode == 1) {
                        box = box.func_72321_a((double)(charge * 2), 0.0, (double)(charge * 2)).func_72317_d((double)(-charge), 0.0, (double)(-charge));
                        dY = -1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72321_a((double)(charge * 2), (double)(charge * 2), 0.0).func_72317_d((double)(-charge), (double)(-1 - charge * 2), 0.0);
                        break;
                    }
                    box = box.func_72321_a(0.0, (double)(charge * 2), (double)(charge * 2)).func_72317_d(0.0, (double)(-1 - charge * 2), (double)(-charge));
                    break;
                }
                case EAST: {
                    box = box.func_72321_a(0.0, (double)(charge * 2), (double)(charge * 2)).func_72317_d(0.0, (double)(-charge), (double)(-charge));
                    dX = 1;
                    break;
                }
                case WEST: {
                    box = box.func_72321_a(0.0, (double)(charge * 2), (double)(charge * 2)).func_72317_d(0.0, (double)(-charge), (double)(-charge));
                    dX = -1;
                    break;
                }
                case SOUTH: {
                    box = box.func_72321_a((double)(charge * 2), (double)(charge * 2), 0.0).func_72317_d((double)(-charge), (double)(-charge), 0.0);
                    dZ = 1;
                    break;
                }
                case NORTH: {
                    box = box.func_72321_a((double)(charge * 2), (double)(charge * 2), 0.0).func_72317_d((double)(-charge), (double)(-charge), 0.0);
                    dZ = -1;
                }
            }
            if (0 == mode) {
                box = box.func_72317_d((double)dX, (double)dY, (double)dZ);
            }
            for (BlockPos currentPos : WorldHelper.getPositionsFromBox(box)) {
                long difference;
                IBlockState oldState = world.func_180495_p(currentPos);
                Block oldBlock = oldState.func_177230_c();
                if (mode == 0 && oldBlock == Blocks.field_150350_a) {
                    if (kleinEmc < (double)reqEmc) break;
                    if (!PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, currentPos, newState, hand)) continue;
                    this.removeKleinEMC(stack, reqEmc);
                    kleinEmc -= (double)reqEmc;
                    continue;
                }
                if (mode != 1 || oldState == newState || oldBlock == Blocks.field_150350_a || world.func_175625_s(currentPos) != null || !EMCHelper.doesItemHaveEmc(ItemHelper.stateToStack(oldState, 1))) continue;
                long emc = EMCHelper.getEmcValue(ItemHelper.stateToStack(oldState, 1));
                if (emc > reqEmc) {
                    if (!PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState, hand)) continue;
                    difference = emc - reqEmc;
                    kleinEmc += MathHelper.func_151237_a((double)kleinEmc, (double)0.0, (double)((IItemEmc)inventory.getStackInSlot(0).func_77973_b()).getMaximumEmc(inventory.getStackInSlot(0)));
                    this.addKleinEMC(stack, difference);
                    continue;
                }
                if (emc < reqEmc) {
                    difference = reqEmc - emc;
                    if (!(kleinEmc >= (double)difference) || !PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState, hand)) continue;
                    kleinEmc -= (double)difference;
                    this.removeKleinEMC(stack, difference);
                    continue;
                }
                PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState, hand);
            }
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.POWER, SoundCategory.PLAYERS, 1.0f, 0.8f + 0.2f / (float)this.getNumCharges(stack) * (float)charge);
        }
        return EnumActionResult.SUCCESS;
    }

    private void addKleinEMC(ItemStack eye, long amount) {
        IItemHandler handler = (IItemHandler)eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack stack = handler.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IItemEmc) {
            ((IItemEmc)stack.func_77973_b()).addEmc(stack, amount);
        }
    }

    private void removeKleinEMC(ItemStack eye, long amount) {
        IItemHandler handler = (IItemHandler)eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack stack = handler.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IItemEmc) {
            ((IItemEmc)stack.func_77973_b()).extractEmc(stack, amount);
        }
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, EnumHand hand) {
        player.openGui((Object)PECore.instance, 12, player.func_130014_f_(), hand == EnumHand.MAIN_HAND ? 0 : 1, -1, -1);
        return true;
    }
}

