/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KleinStar
extends ItemPE
implements IItemEmc {
    public KleinStar() {
        this.func_77655_b("klein_star");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double starEmc = KleinStar.getEmc(stack);
        if (starEmc == 0.0) {
            return 1.0;
        }
        return 1.0 - starEmc / (double)EMCHelper.getKleinStarMaxEmc(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && PECore.DEV_ENVIRONMENT) {
            KleinStar.setEmc(stack, EMCHelper.getKleinStarMaxEmc(stack));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() > 5) {
            return "pe.debug.metainvalid";
        }
        return super.func_77658_a() + "_" + (stack.func_77952_i() + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs cTab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(cTab)) {
            for (int i = 0; i < 6; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Override
    public double addEmc(@Nonnull ItemStack stack, double toAdd) {
        double add = Math.min(this.getMaximumEmc(stack) - this.getStoredEmc(stack), toAdd);
        ItemPE.addEmcToStack(stack, add);
        return add;
    }

    @Override
    public double extractEmc(@Nonnull ItemStack stack, double toRemove) {
        double sub = Math.min(this.getStoredEmc(stack), toRemove);
        ItemPE.removeEmc(stack, sub);
        return sub;
    }

    @Override
    public double getStoredEmc(@Nonnull ItemStack stack) {
        return ItemPE.getEmc(stack);
    }

    @Override
    public double getMaximumEmc(@Nonnull ItemStack stack) {
        return EMCHelper.getKleinStarMaxEmc(stack);
    }

    public static enum EnumKleinTier {
        EIN("ein"),
        ZWEI("zwei"),
        DREI("drei"),
        VIER("vier"),
        SPHERE("sphere"),
        OMEGA("omega");

        public final String name;

        private EnumKleinTier(String name) {
            this.name = name;
        }
    }
}

