/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class BlacklistBlocks {
    private static ArrayList<String> blacklistedBlocks = new ArrayList();

    @Nonnull
    private static ResourceLocation getName(Block block) {
        ResourceLocation name = block.getRegistryName();
        if (name == null) {
            throw new IllegalArgumentException("A registry name for the following block could not be found: " + block);
        }
        return name;
    }

    private static void addBlockToBlacklist(Block block) {
        blacklistedBlocks.add(BlacklistBlocks.getName(block).toString());
    }

    private static void addStringToBlacklist(String name) {
        blacklistedBlocks.add(name);
    }

    private static void setConfig(Configuration cfg, List<String> blacklist) {
        String[] tempArray = new String[blacklist.size()];
        blacklist.toArray(tempArray);
        cfg.get("blockBlacklist", "Blacklist", tempArray);
    }

    public static boolean checkBlacklist(Block block) {
        return blacklistedBlocks.contains(BlacklistBlocks.getName(block).toString());
    }

    public static void getBlacklist(Configuration cfg) {
        ConfigCategory category = cfg.getCategory("blockBlacklist");
        if (category.isEmpty()) {
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180413_ao);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180412_aq);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180410_as);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180409_at);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_150454_av);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180411_ar);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_180414_ap);
            BlacklistBlocks.addBlockToBlacklist((Block)Blocks.field_150332_K);
            BlacklistBlocks.setConfig(cfg, blacklistedBlocks);
        } else {
            for (String entry : category.get("Blacklist").getStringList()) {
                BlacklistBlocks.addStringToBlacklist(entry);
            }
        }
    }
}

