/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.items.ItemCaps.CapabilityProviderEnergy;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GenericGadget
extends Item {
    public int getEnergyMax() {
        return Config.energyMax;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound tag) {
        if (Config.poweredByFE) {
            return new CapabilityProviderEnergy(stack, this.getEnergyMax());
        }
        return null;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (Config.poweredByFE) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (Config.poweredByFE) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        if (Config.poweredByFE) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return energy.getEnergyStored() != energy.getMaxEnergyStored();
        }
        return super.isDamaged(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (Config.poweredByFE) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return energy.getEnergyStored() != energy.getMaxEnergyStored();
        }
        return super.showDurabilityBar(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (Config.poweredByFE) {
            return false;
        }
        return repair.func_77973_b() == Items.field_151045_i;
    }
}

