/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.gui;

import com.direwolf20.buildinggadgets.KeyBindings;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.DestructionTool;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.items.GenericGadget;
import com.direwolf20.buildinggadgets.network.PacketHandler;
import com.direwolf20.buildinggadgets.network.PacketToggleMode;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class ModeRadialMenu
extends GuiScreen {
    private static final ResourceLocation[] signs = new ResourceLocation[]{new ResourceLocation("buildinggadgets:textures/ui/buildtome.png"), new ResourceLocation("buildinggadgets:textures/ui/verticalcolumn.png"), new ResourceLocation("buildinggadgets:textures/ui/horizontalcolumn.png"), new ResourceLocation("buildinggadgets:textures/ui/verticalwall.png"), new ResourceLocation("buildinggadgets:textures/ui/horizontalwall.png"), new ResourceLocation("buildinggadgets:textures/ui/stairs.png"), new ResourceLocation("buildinggadgets:textures/ui/checker.png")};
    private int timeIn = 0;
    private int slotSelected = -1;
    private List<Integer> slots;

    public ModeRadialMenu(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        if (stack.func_77973_b() instanceof BuildingTool) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof ExchangerTool) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof CopyPasteTool) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof DestructionTool) {
            this.setSocketable(stack);
        }
    }

    public void setSocketable(ItemStack stack) {
        this.slots = new ArrayList<Integer>();
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof BuildingTool) {
            for (int i = 0; i < BuildingTool.ToolMode.values().length; ++i) {
                this.slots.add(i);
            }
        } else if (stack.func_77973_b() instanceof ExchangerTool) {
            for (int i = 0; i < ExchangerTool.ToolMode.values().length; ++i) {
                this.slots.add(i);
            }
        } else if (stack.func_77973_b() instanceof CopyPasteTool) {
            for (int i = 0; i < CopyPasteTool.ToolMode.values().length; ++i) {
                this.slots.add(i);
            }
        } else if (stack.func_77973_b() instanceof DestructionTool) {
            // empty if block
        }
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        if (this.slots.equals(new ArrayList())) {
            return;
        }
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        int maxRadius = 80;
        boolean mouseIn = true;
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        int highlight = 5;
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        int segments = this.slots.size();
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)segments;
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack tool = player.func_184614_ca();
        if (!(tool.func_77973_b() instanceof GenericGadget) && !((tool = player.func_184592_cb()).func_77973_b() instanceof GenericGadget)) {
            return;
        }
        this.slotSelected = -1;
        for (int seg = 0; seg < segments; ++seg) {
            boolean mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            GL11.glBegin((int)6);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs;
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                if (!tool.func_190926_b()) {
                    Color color = new Color(255, 255, 255);
                    r = (float)color.getRed() / 255.0f;
                    g = (float)color.getGreen() / 255.0f;
                    b = (float)color.getBlue() / 255.0f;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            GL11.glVertex2i((int)x, (int)y);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, mouseInSector ? 110 : 114});
                }
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
            if (!mouseInSector) continue;
            radius -= (float)highlight;
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int[] pos : stringPositions) {
            int slot = this.slots.get(pos[0]);
            int xp = pos[1];
            int yp = pos[2];
            char c = (char)pos[3];
            String name = "";
            if (tool.func_77973_b() instanceof BuildingTool) {
                BuildingTool.ToolMode mode = BuildingTool.ToolMode.values()[slot];
                name = "\u00a7" + c + mode.name();
            } else if (tool.func_77973_b() instanceof ExchangerTool) {
                ExchangerTool.ToolMode mode = ExchangerTool.ToolMode.values()[slot];
                name = "\u00a7" + c + mode.name();
            } else if (tool.func_77973_b() instanceof CopyPasteTool) {
                CopyPasteTool.ToolMode mode = CopyPasteTool.ToolMode.values()[slot];
                name = "\u00a7" + c + mode.name();
            }
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_146289_q.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.field_146289_q.func_175063_a(name, (float)xsp, (float)ysp, 0xFFFFFF);
            mod = 0.8;
            xdp = (int)((double)(xp - x) * mod + (double)x);
            ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a(signs[slot]);
            ModeRadialMenu.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        float s = 3.0f * fract;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        if (!tool.func_190926_b()) {
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            GlStateManager.func_179109_b((float)((float)x / s - 8.0f), (float)((float)y / s - 8.0f), (float)0.0f);
            this.field_146297_k.func_175599_af().func_180450_b(tool, 0, 0);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!GameSettings.func_100015_a((KeyBinding)KeyBindings.modeSwitch)) {
            this.field_146297_k.func_147108_a(null);
            if (this.slotSelected != -1) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleMode(this.slotSelected));
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)GameSettings.func_100015_a((KeyBinding)k));
        }
        ++this.timeIn;
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

