/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shadows.placebo.Placebo;

public class PlaceboLootSystem {
    public static final Map<ResourceLocation, LootTable> PLACEBO_TABLES = new HashMap<ResourceLocation, LootTable>();

    @SubscribeEvent
    public void loadTables(LootTableLoadEvent e) {
        if (!e.getName().equals((Object)LootTableList.field_186422_d)) {
            return;
        }
        ConcurrentMap tables = e.getLootTableManager().field_186527_c.asMap();
        for (Map.Entry<ResourceLocation, LootTable> et : PLACEBO_TABLES.entrySet()) {
            if (!tables.containsValue(et.getValue())) continue;
            tables.put(et.getKey(), et.getValue());
        }
    }

    public static void registerLootTable(ResourceLocation key, LootTable table) {
        if (!PLACEBO_TABLES.containsKey(key)) {
            PLACEBO_TABLES.put(key, table);
        } else {
            Placebo.LOG.warn("Duplicate loot entry detected, this is not allowed!  Key: " + key);
        }
    }
}

