/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.Infusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spawner.GuiMatterBeamer;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.MatterBeamerRenderer;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MatterBeamerBlock
extends GenericRFToolsBlock<MatterBeamerTileEntity, MatterBeamerContainer>
implements Infusable {
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");

    public MatterBeamerBlock() {
        super(Material.field_151573_f, MatterBeamerTileEntity.class, MatterBeamerContainer::new, "matter_beamer", true);
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(MatterBeamerTileEntity.class, (TileEntitySpecialRenderer)new MatterBeamerRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block converts matter into a beam");
            list.add(TextFormatting.WHITE + "of energy. It can then send that beam to");
            list.add(TextFormatting.WHITE + "a connected spawner. Connect by using a wrench.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power usage");
            list.add(TextFormatting.YELLOW + "increased speed and less material needed");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)te;
            BlockPos coordinate = matterBeamerTileEntity.getDestination();
            if (coordinate == null) {
                probeInfo.text(TextFormatting.RED + "Not connected to a spawner!");
            } else {
                probeInfo.text(TextFormatting.GREEN + "Connected!");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)te;
            BlockPos coordinate = matterBeamerTileEntity.getDestination();
            if (coordinate == null) {
                currenttip.add(TextFormatting.RED + "Not connected to a spawner!");
            } else {
                currenttip.add(TextFormatting.GREEN + "Connected!");
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<MatterBeamerTileEntity, MatterBeamerContainer, GenericGuiContainer<? super MatterBeamerTileEntity>> getGuiFactory() {
        return GuiMatterBeamer::new;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_BEAMER;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (world.field_72995_K) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)world.func_175625_s(pos);
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.note.pling")), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            matterBeamerTileEntity.useWrench(player);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        boolean working = false;
        if (te instanceof MatterBeamerTileEntity) {
            working = ((MatterBeamerTileEntity)te).isGlowing();
        }
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(working));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WORKING});
    }
}

