/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

@FunctionalInterface
public interface Cutter {
    @Nonnull
    public List<String> split(@Nonnull String var1, @Nonnegative int var2);

    public static class DefaultWordCutter
    implements Cutter {
        @Override
        @Nonnull
        public List<String> split(@Nonnull String message, @Nonnegative int size) {
            Sanity.nullCheck(message, "Message cannot be null");
            Sanity.truthiness(size > 0, "Size must be positive");
            ArrayList<String> list = new ArrayList<String>();
            if (message.length() <= size) {
                list.add(message);
                return list;
            }
            StringBuilder builder = new StringBuilder(size);
            for (String word : message.split(" ")) {
                if (builder.length() + word.length() + (builder.length() == 0 ? 0 : 1) > size) {
                    if (word.length() > size && builder.length() + 1 < size) {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        int cut = size - builder.length();
                        builder.append(word.substring(0, cut));
                        word = word.substring(cut);
                    }
                    list.add(builder.toString().trim());
                    builder.setLength(0);
                    while (word.length() > size) {
                        list.add(word.substring(0, size));
                        word = word.substring(size);
                    }
                }
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(word);
            }
            if (builder.length() > 0) {
                list.add(builder.toString().trim());
            }
            return list;
        }
    }
}

