/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.element;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public interface ServerMessage {
    @Nonnull
    public String getMessage();

    @Nonnull
    public List<MessageTag> getTags();

    default public Optional<MessageTag> getTag(@Nonnull String name) {
        Sanity.nullCheck(name, "Name cannot be null");
        return this.getTags().stream().filter(tag -> tag.getName().equals(name)).findAny();
    }

    @Nonnull
    default public <Tag extends MessageTag> Optional<Tag> getTag(@Nonnull String name, @Nonnull Class<Tag> clazz) {
        Sanity.nullCheck(name, "Name cannot be null");
        Sanity.nullCheck(clazz, "Class cannot be null");
        return this.getTags().stream().filter(tag -> tag.getName().equals(name)).filter(clazz::isInstance).map(tag -> tag).findAny();
    }

    public static interface NumericCommandServerMessage
    extends ServerMessage {
        public int getCommand();
    }

    public static interface StringCommandServerMessage
    extends ServerMessage {
        @Nonnull
        public String getCommand();
    }
}

