/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class OperCommand
extends Command {
    private String user;
    private String password;

    public OperCommand(@Nonnull Client client) {
        super(client);
    }

    @Nonnull
    public OperCommand user(@Nonnull String user) {
        this.user = Sanity.safeMessageCheck(user, "user");
        return this;
    }

    @Nonnull
    public OperCommand password(@Nonnull String password) {
        this.password = Sanity.safeMessageCheck(password, "password");
        return this;
    }

    @Override
    public void execute() {
        if (this.user == null) {
            throw new IllegalStateException("User not defined");
        }
        if (this.password == null) {
            throw new IllegalStateException("Password not defined");
        }
        this.getClient().sendRawLine("OPER " + this.user + ' ' + this.password);
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("user", this.user == null ? null : "AzureDiamond").add("password", this.password == null ? null : "hunter2");
    }
}

