/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class MonitorCommand
extends Command {
    private Action action;
    private Set<String> targets;

    public MonitorCommand(@Nonnull Client client) {
        super(client);
    }

    @Nonnull
    public MonitorCommand action(@Nonnull Action action) {
        this.action = Sanity.nullCheck(action, "Action cannot be null");
        return this;
    }

    @Nonnull
    public MonitorCommand target(String ... targets) {
        return this.target(Arrays.asList(Sanity.nullCheck(targets, "Targets cannot be null")));
    }

    @Nonnull
    public synchronized MonitorCommand target(@Nonnull Collection<String> targets) {
        Sanity.nullCheck(targets, "Targets cannot be null");
        LinkedHashSet<String> targetSet = new LinkedHashSet<String>();
        for (String target : targets) {
            Sanity.safeMessageCheck(target, "target");
            Sanity.truthiness(target.indexOf(44) == -1, "Target cannot contain a comma");
            targetSet.add(target);
        }
        this.targets = targetSet;
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.action == null) {
            throw new IllegalStateException("Action not defined");
        }
        if (this.action == Action.ADD_TARGET || this.action == Action.REMOVE_TARGET) {
            if (this.targets == null || this.targets.isEmpty()) {
                throw new IllegalStateException("Target(s) not defined");
            }
            StringBuilder builder = new StringBuilder(200);
            for (String request : this.targets) {
                if (builder.length() > 0 && request.length() + builder.length() > 200) {
                    this.monitorCommand(this.action, builder.toString());
                    builder.setLength(0);
                }
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(request);
            }
            this.monitorCommand(this.action, builder.toString());
        } else {
            this.monitorCommand(this.action);
        }
    }

    private void monitorCommand(@Nonnull Action action) {
        this.getClient().sendRawLine("MONITOR " + action.getCharacter());
    }

    private void monitorCommand(@Nonnull Action action, @Nonnull String targets) {
        this.getClient().sendRawLine("MONITOR " + action.getCharacter() + ' ' + targets);
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("action", (Object)this.action).add("targets", this.targets);
    }

    public static enum Action {
        ADD_TARGET('+'),
        CLEAR_ALL_TARGETS('C'),
        LIST_TARGETS('L'),
        REMOVE_TARGET('-'),
        STATUS_OUTPUT_ALL('S');

        private final char character;

        private Action(char character) {
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }
    }
}

