/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.client;

import com.feed_the_beast.ftbguides.FTBGuides;
import com.feed_the_beast.ftbguides.client.FTBGuidesClient;
import com.feed_the_beast.ftbguides.client.FTBGuidesClientConfig;
import com.feed_the_beast.ftbguides.client.GuideTheme;
import com.feed_the_beast.ftbguides.events.ClientGuideEvent;
import com.feed_the_beast.ftbguides.gui.GuiGuide;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.GuideTitlePage;
import com.feed_the_beast.ftbguides.gui.GuideType;
import com.feed_the_beast.ftbguides.gui.SpecialGuideButton;
import com.feed_the_beast.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.TextGuideComponent;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.client.SidebarButton;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.client.SidebarButtonManager;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;

class ThreadLoadGuides
extends Thread {
    GuiLoading gui;
    GuidePage root;
    private boolean loaded = false;

    ThreadLoadGuides() {
        super("ReloadGuides");
        this.setDaemon(true);
        this.gui = new GuiLoading(){

            public void finishLoading() {
                FTBGuidesClient.reloadingThread = null;
                if (ThreadLoadGuides.this.loaded) {
                    FTBGuidesClient.guidesGui = new GuiGuide(ThreadLoadGuides.this.root);
                    FTBGuidesClient.openGuidesGui("");
                } else {
                    ThreadLoadGuides.this.gui.closeGui(false);
                }
            }
        };
    }

    @Override
    public void run() {
        try {
            String s = this.run1();
            if (!s.isEmpty()) {
                FTBGuides.LOGGER.error(s);
            }
            this.loaded = true;
        }
        catch (Exception ex) {
            FTBGuidesClient.reloadingThread = null;
            ex.printStackTrace();
        }
        this.gui.setFinished();
    }

    public String run1() {
        File[] modGuideFiles;
        block29: {
            GuideTheme.THEMES.clear();
            try {
                for (IResource resource : ClientUtils.MC.func_110442_L().func_135056_b(new ResourceLocation("ftbguides", "themes/index.json"))) {
                    JsonElement json = DataReader.get((IResource)resource).json();
                    if (!json.isJsonArray()) continue;
                    for (JsonElement element : json.getAsJsonArray()) {
                        String id = element.getAsString();
                        JsonElement json1 = DataReader.get((IResource)ClientUtils.MC.func_110442_L().func_110536_a(new ResourceLocation("ftbguides", "themes/" + id + ".json"))).json();
                        if (!json1.isJsonObject()) continue;
                        JsonObject o = json1.getAsJsonObject();
                        GuideTheme theme = new GuideTheme(id);
                        GuideTheme.THEMES.put(id, theme);
                        theme.title = o.has("title") ? JsonUtils.deserializeTextComponent((JsonElement)o.get("title")) : new TextComponentString(id);
                        theme.background = Icon.getIcon((JsonElement)o.get("background"));
                        theme.text = Color4I.fromJson((JsonElement)o.get("text"));
                        theme.textMouseOver = Color4I.fromJson((JsonElement)o.get("text_mouse_over"));
                        theme.lines = Color4I.fromJson((JsonElement)o.get("lines"));
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) break block29;
                ex.printStackTrace();
            }
        }
        if (!GuideTheme.THEMES.isEmpty()) {
            GuideTheme prevTheme = null;
            for (GuideTheme theme : GuideTheme.THEMES.values()) {
                if (prevTheme != null) {
                    prevTheme.next = theme;
                }
                prevTheme = theme;
            }
            if (prevTheme != null) {
                prevTheme.next = GuideTheme.THEMES.values().iterator().next();
            }
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBGuides.LOGGER.info("Loaded Guide Themes: " + GuideTheme.THEMES.values());
        }
        this.root = new GuidePage("root", null);
        this.root.title = new TextComponentTranslation("ftbguides.lang.home", new Object[0]);
        try {
            this.root.textURI = new URI("https://raw.githubusercontent.com/LatvianModder/FTBGuidesWeb/master");
            this.root.textLoadingState = 2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Base path is incorrect!";
        }
        ArrayList<GuideTitlePage> guides = new ArrayList<GuideTitlePage>();
        this.gui.setTitle("Loading Guides\n" + I18n.func_135052_a((String)"ftbguides.lang.type.modpack", (Object[])new Object[0]));
        JsonElement modpackGuide = DataReader.get((File)new File(Loader.instance().getConfigDir(), "ftbguides/modpack_guide/data.json")).safeJson();
        if (modpackGuide.isJsonObject()) {
            GuideTitlePage page = new GuideTitlePage("modpack_guide", this.root, GuideType.MODPACK);
            File[] folder = new File(Loader.instance().getConfigDir(), "ftbguides/modpack_guide");
            page.textURI = folder.toURI().resolve("index.json");
            this.loadLocalPage((File)folder, page, modpackGuide.getAsJsonObject());
            page.properties.put("browser_url", new JsonPrimitive(""));
            guides.add(page);
        }
        if ((modGuideFiles = new File(Loader.instance().getConfigDir(), "ftbguides/mod_guides").listFiles()) != null && modGuideFiles.length > 0) {
            for (File modGuideFile : modGuideFiles) {
                String modid;
                if (!modGuideFile.isDirectory()) continue;
                this.gui.setTitle("Loading Guides\n" + I18n.func_135052_a((String)"ftbguides.lang.type.mod", (Object[])new Object[0]) + '\n' + modGuideFile.getName());
                JsonElement modGuide = DataReader.get((File)new File(modGuideFile, "data.json")).safeJson();
                if (!modGuide.isJsonObject()) continue;
                JsonObject json = modGuide.getAsJsonObject();
                String string = modid = json.has("modid") ? json.get("modid").getAsString() : "";
                if (FTBGuidesClientConfig.general.hide_mods_not_present && !modid.isEmpty() && !Loader.isModLoaded((String)modid)) continue;
                GuideTitlePage page = new GuideTitlePage(modGuideFile.getName(), this.root, GuideType.MOD);
                page.textURI = modGuideFile.toURI().resolve("index.json");
                this.loadLocalPage(modGuideFile, page, json);
                page.properties.put("browser_url", new JsonPrimitive(""));
                guides.add(page);
            }
        }
        this.gui.setTitle("Loading Guides\nAPI");
        try {
            JsonElement apijson = DataReader.get((URL)new URL("https://guides.latmod.com/api/api.json"), (String)"application/json; charset=utf-8", (Proxy)ClientUtils.MC.func_110437_J()).json();
            JsonObject api = apijson.getAsJsonObject();
            JsonArray guidesArray = api.get("guides").getAsJsonArray();
            for (JsonElement e : guidesArray) {
                JsonObject o = e.getAsJsonObject();
                String id = o.get("id").getAsString();
                GuideType type = (GuideType)((Object)GuideType.NAME_MAP.get(o.get("type").getAsString()));
                if (type == GuideType.MOD && FTBGuidesClientConfig.general.hide_mods_not_present && o.has("modid") && !Loader.isModLoaded((String)o.get("modid").getAsString()) || type == GuideType.OTHER && FTBGuidesClientConfig.general.hide_other) continue;
                GuideTitlePage page = new GuideTitlePage(id, this.root, type);
                if (o.has("authors")) {
                    for (JsonElement e1 : o.get("authors").getAsJsonArray()) {
                        page.authors.add(e1.getAsString());
                    }
                }
                try {
                    this.loadPage(page, o);
                    guides.add(page);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuideTitlePage page = new GuideTitlePage("online_guides", this.root, GuideType.OTHER);
            page.title = new TextComponentString("Online Guides");
            page.icon = GuidePage.DEFAULT_ICON;
            page.println(StringUtils.color((ITextComponent)new TextComponentString("Failed to load online guides! Error: " + ex.getMessage()), (TextFormatting)TextFormatting.RED));
            guides.add(page);
        }
        this.gui.setTitle("Loading Guides\n" + I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]));
        GuideTitlePage sidebarButtons = new GuideTitlePage("sidebar_buttons", this.root, GuideType.OTHER);
        sidebarButtons.isPresent = true;
        sidebarButtons.authors.add("LatvianModder");
        sidebarButtons.icon = Icon.getIcon((String)"ftblib:textures/gui/teams.png");
        sidebarButtons.title = new TextComponentTranslation("sidebar_button", new Object[0]);
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
            for (SidebarButton button : group.getButtons()) {
                if (!button.isVisible() || !I18n.func_188566_a((String)button.getTooltipLangKey())) continue;
                GuidePage page1 = sidebarButtons.getSub(button.id.toString());
                page1.icon = button.getIcon();
                page1.title = new TextComponentTranslation(button.getLangKey(), new Object[0]);
                page1.println((ITextComponent)new TextComponentTranslation(button.getTooltipLangKey(), new Object[0]));
            }
        }
        this.gui.setTitle("Loading Guides\nMod Guides");
        HashMap<String, GuideTitlePage> eventMap = new HashMap<String, GuideTitlePage>();
        new ClientGuideEvent(this.root, eventMap).post();
        guides.addAll(eventMap.values());
        if (FTBGuidesClient.serverGuideClient != null && SidedUtils.isModLoadedOnServer((String)"ftbguides")) {
            for (Map.Entry entry : FTBGuidesClient.serverGuideClient.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                GuideTitlePage page = new GuideTitlePage((String)entry.getKey(), this.root, GuideType.SERVER_INFO);
                this.loadServerPage(page, ((JsonElement)entry.getValue()).getAsJsonObject());
                guides.add(page);
            }
        }
        for (GuideTitlePage guide : guides) {
            this.root.addSub(guide);
        }
        this.gui.setTitle("Loading Guides\nFinishing");
        this.root.properties.put("browser_url", (JsonElement)new JsonPrimitive("https://guides.latmod.com"));
        this.root.addSub(sidebarButtons);
        this.root.cleanup();
        this.root.updateCachedProperties(true);
        this.root.sort(false);
        for (GuideType type : GuideType.NAME_MAP) {
            boolean added = false;
            for (GuideTitlePage page : guides) {
                if (page.type != type) continue;
                if (!added) {
                    added = true;
                    this.root.println(new TextGuideComponent(I18n.func_135052_a((String)type.titlePlural, (Object[])new Object[0])).setProperty("text_scale", "1.5").setProperty("bold", "true"));
                }
                this.root.println(new TextGuideComponent(page.title.func_150260_c()).setProperty("icon", page.icon.toString()).setProperty("click", page.getID()));
            }
        }
        this.root.println(HRGuideComponent.INSTANCE);
        return "";
    }

    private void loadPageBase(GuidePage page, JsonObject json) {
        TextComponentString textComponentString = page.title = json.has("title") ? new TextComponentString(json.get("title").getAsString()) : new TextComponentString(page.getID());
        if (FTBLibConfig.debugging.print_more_info && page.textURI != null) {
            FTBGuides.LOGGER.info("Base path of " + page.getPath() + ": " + page.textURI.resolve("."));
        }
        if (!json.has("icon")) {
            json.addProperty("icon", "icon.png");
        }
        page.icon = page.getIcon(json.get("icon").getAsString());
        if (page.icon.isEmpty()) {
            page.icon = Icon.getIcon((String)json.get("icon_url").getAsString());
            if (page.icon.isEmpty()) {
                page.icon = GuidePage.DEFAULT_ICON;
            }
        }
        if (json.has("buttons")) {
            for (JsonElement e : json.get("buttons").getAsJsonArray()) {
                page.specialButtons.add(new SpecialGuideButton(e.getAsJsonObject()));
            }
        }
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            if (GuidePage.STANDARD_KEYS.contains(key)) continue;
            page.properties.put(key, (JsonElement)entry.getValue());
        }
    }

    private void loadPage(GuidePage page, JsonObject json) throws Exception {
        page.textURI = new URI(json.get("original_text_url").getAsString());
        this.loadPageBase(page, json);
        if (json.has("pages")) {
            for (JsonElement e : json.get("pages").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                this.loadPage(page.getSub(o.get("id").getAsString()), o);
            }
        }
        page.properties.put("browser_url", (JsonElement)new JsonPrimitive("https://guides.latmod.com" + page.getPath()));
    }

    private void loadLocalPage(File folder, GuidePage page, JsonObject json) {
        this.loadPageBase(page, json);
        if (json.has("pages")) {
            for (JsonElement e : json.get("pages").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                String id = o.get("id").getAsString();
                File folder1 = new File(folder, id);
                GuidePage page1 = page.getSub(id);
                this.loadLocalPage(folder1, page1, o);
                try {
                    File shortFile = new File(folder, id + ".json");
                    if (shortFile.exists()) {
                        page1.textURI = shortFile.toURI();
                        continue;
                    }
                    page1.textURI = new File(folder1, "index.json").toURI();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void loadServerPage(GuidePage page, JsonObject json) {
        this.loadPageBase(page, json);
        try {
            page.textURI = new URI("ftp", page.getPath(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (json.has("pages")) {
            for (JsonElement e : json.get("pages").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                String id = o.get("id").getAsString();
                GuidePage page1 = page.getSub(id);
                this.loadServerPage(page1, o);
            }
        }
    }
}

