/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import ic2.core.IC2;
import ic2.core.ProfileManager;
import ic2.core.block.personal.TileEntityPersonalChestRenderer;
import ic2.core.block.state.IIdProvider;
import ic2.core.block.type.ResourceBlock;
import ic2.core.item.ItemIC2;
import ic2.core.item.type.CraftingItemType;
import ic2.core.item.type.UpdateKitType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import ic2.core.util.Tuple;
import ic2.core.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SuddenlyTextures
extends TextureAtlasSprite {
    private static final EnumFacing[] FILE_ORDER = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH};
    private static final FileResourcePack PACK = new FileResourcePack(ProfileManager.getPack());
    private static final Map<ResourceLocation, String> knownItems = new HashMap<ResourceLocation, String>();
    private static final Map<String, Map<? extends IIdProvider, String>> knownBlocks;
    private static final Map<TeBlock, String> knownTeBlocks;
    protected final String file;
    protected final String domain;
    protected final int offset;
    private static final Field ANMIATION;

    private static ModelLoader findLoader() {
        String target = ModelLoader.class.getName() + "$VanillaLoader";
        try {
            Class<?> type = Class.forName(target);
            Field f = ReflectionUtil.getField(type, type);
            Object instance = ReflectionUtil.getFieldValue(f, null);
            f = ReflectionUtil.getField(type, ModelLoader.class);
            return (ModelLoader)ReflectionUtil.getFieldValue(f, instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't find loader: " + target, e);
        }
    }

    private static ModelBlockDefinition getDefinition(ModelLoader loader, ResourceLocation location) {
        Method m = ReflectionUtil.getMethod(ModelLoader.class, new String[]{"func_177586_a", "getModelBlockDefinition", "a"}, ResourceLocation.class);
        try {
            return (ModelBlockDefinition)m.invoke((Object)loader, location);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error getting blockstate for " + location + " using " + loader, e);
        }
    }

    private static Function<ResourceLocation, ModelBlock> makeModelFactory(ModelBakery bakery) {
        try {
            Method m = ReflectionUtil.getMethod(ModelBakery.class, new String[]{"func_177594_c", "loadModel", "c"}, ResourceLocation.class);
            MethodHandle handle = MethodHandles.lookup().unreflect(m);
            return loc -> {
                try {
                    return handle.invokeExact(bakery, (ResourceLocation)loc);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error getting block model", t);
                }
            };
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error finding model loading method in " + bakery, e);
        }
    }

    private static ResourceLocation correctItem(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/item/" + location.func_110623_a());
    }

    private static ResourceLocation correctBlock(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a());
    }

    private static List<ResourceLocation> getTextures(ModelBlockDefinition blockstates, Function<ResourceLocation, ModelBlock> modelFactory, String variantName) {
        if (blockstates.func_188000_b(variantName)) {
            for (Variant variant : blockstates.func_188004_c(variantName).func_188114_a()) {
                try {
                    ModelBlock model = modelFactory.apply(SuddenlyTextures.correctBlock(variant.func_188046_a()));
                    ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
                    if (model.field_178318_c.size() == 1) {
                        ResourceLocation texture = new ResourceLocation((String)model.field_178318_c.get("all"));
                        for (int i = 0; i < FILE_ORDER.length; ++i) {
                            textures.add(texture);
                        }
                    } else {
                        if (model.field_178318_c.size() != FILE_ORDER.length) {
                            model.field_178315_d = modelFactory.apply(SuddenlyTextures.correctBlock(model.func_178305_e()));
                        }
                        for (EnumFacing side : FILE_ORDER) {
                            assert (model.func_178300_b(side.func_176610_l())) : variantName;
                            textures.add(new ResourceLocation(model.func_178308_c(side.func_176610_l())));
                        }
                    }
                    return textures;
                }
                catch (Exception e) {
                    IC2.log.warn(LogCategory.Block, e, "Unable to load block model: '%s' for variant: %s", variant.func_188046_a(), variantName);
                }
            }
        }
        return Collections.emptyList();
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        List<ResourceLocation> textures;
        ModelLoader loader = SuddenlyTextures.findLoader();
        Function<ResourceLocation, ModelBlock> modelFactory = SuddenlyTextures.makeModelFactory((ModelBakery)loader);
        HashSet<ResourceLocation> seen = new HashSet<ResourceLocation>();
        TextureMap map = event.getMap();
        for (Map.Entry<ResourceLocation, String> entry : knownItems.entrySet()) {
            ModelBlock modelBlock = modelFactory.apply(SuddenlyTextures.correctItem(entry.getKey()));
            assert (modelBlock.func_178300_b("layer0"));
            map.setTextureEntry((TextureAtlasSprite)SuddenlyTextures.asItem(new ResourceLocation((String)modelBlock.field_178318_c.get("layer0")), entry.getValue()));
        }
        SuddenlyTextures.doObscurator(map);
        ModelBlockDefinition blockstates = null;
        for (Map.Entry<String, Map<? extends IIdProvider, String>> entry : knownBlocks.entrySet()) {
            blockstates = SuddenlyTextures.getDefinition(loader, new ResourceLocation("ic2", entry.getKey()));
            for (Map.Entry<? extends IIdProvider, String> entry2 : entry.getValue().entrySet()) {
                IIdProvider block = entry2.getKey();
                List<ResourceLocation> textures2 = SuddenlyTextures.getTextures(blockstates, modelFactory, "type=" + block.getName());
                if (textures2.size() != FILE_ORDER.length) {
                    throw new IllegalStateException("Found: " + textures2);
                }
                for (int offset = 0; offset < textures2.size(); ++offset) {
                    ResourceLocation real = textures2.get(offset);
                    assert (real != null);
                    if (!seen.add(real)) continue;
                    map.setTextureEntry((TextureAtlasSprite)SuddenlyTextures.asBlock(real, entry2.getValue(), offset));
                }
            }
        }
        blockstates = SuddenlyTextures.getDefinition(loader, new ResourceLocation("ic2", BlockName.te.name()));
        for (Map.Entry<TeBlock, String> entry : knownTeBlocks.entrySet()) {
            TeBlock block = entry.getKey();
            textures = SuddenlyTextures.getTextures(blockstates, modelFactory, "facing=north,type=" + block.getName());
            if (textures.size() != FILE_ORDER.length) {
                throw new IllegalStateException("Found: " + textures);
            }
            if (block.hasActive()) {
                textures.addAll(SuddenlyTextures.getTextures(blockstates, modelFactory, "facing=north,type=" + block.getName() + "_active"));
                if (textures.size() != FILE_ORDER.length * 2) {
                    throw new IllegalStateException("Found: " + textures);
                }
            }
            for (int offset = 0; offset < textures.size(); ++offset) {
                ResourceLocation real = textures.get(offset);
                assert (real != null);
                if (!seen.add(real)) continue;
                map.setTextureEntry((TextureAtlasSprite)SuddenlyTextures.asBlock(real, entry.getValue(), offset));
            }
        }
        SuddenlyTextures.doPersonalChest(map, blockstates, modelFactory);
        String string = "compactsolars";
        blockstates = SuddenlyTextures.getDefinition(loader, new ResourceLocation("compactsolars", "compact_solar_block"));
        for (Tuple.T2 type : Arrays.asList(new Tuple.T2<String, String>("low_voltage", "lv"), new Tuple.T2<String, String>("medium_voltage", "mv"), new Tuple.T2<String, String>("high_voltage", "hv"))) {
            textures = SuddenlyTextures.getTextures(blockstates, modelFactory, "type=" + (String)type.a);
            if (textures.isEmpty()) continue;
            assert (textures.size() == 6);
            ResourceLocation side = textures.remove(0);
            if (seen.add(side)) {
                map.setTextureEntry((TextureAtlasSprite)new SuddenlyTextures(side, "compactsolars", "blocks/" + (String)type.b + "Bottom.png", -1));
            }
            if (seen.add(side = textures.remove(0))) {
                map.setTextureEntry((TextureAtlasSprite)new SuddenlyTextures(side, "compactsolars", "blocks/" + (String)type.b + "Top.png", -1));
            }
            for (ResourceLocation texture : textures) {
                if (!seen.add(texture)) continue;
                map.setTextureEntry((TextureAtlasSprite)new SuddenlyTextures(texture, "compactsolars", "blocks/" + (String)type.b + "Side.png", -1));
            }
        }
    }

    private static void doObscurator(TextureMap map) {
    }

    private static void doPersonalChest(TextureMap map, ModelBlockDefinition blockstates, Function<ResourceLocation, ModelBlock> modelFactory) {
        String personalChestVarient = "facing=north,type=" + TeBlock.personal_chest.getName();
        if (blockstates.func_188000_b(personalChestVarient)) {
            HashSet<ResourceLocation> seen = new HashSet<ResourceLocation>();
            for (Variant variant : blockstates.func_188004_c(personalChestVarient).func_188114_a()) {
                try {
                    ModelBlock model = modelFactory.apply(SuddenlyTextures.correctBlock(variant.func_188046_a()));
                    String file = "models/newsafe.png";
                    ResourceLocation side = new ResourceLocation(model.func_178308_c("leftrightback"));
                    if (seen.add(side)) {
                        map.setTextureEntry((TextureAtlasSprite)SuddenlyTextures.fromPosition(side, "models/newsafe.png", 0, 1));
                    }
                    if (!seen.add(side = new ResourceLocation(model.func_178308_c("bottomtop")))) continue;
                    map.setTextureEntry((TextureAtlasSprite)SuddenlyTextures.fromPosition(side, "models/newsafe.png", 0, 17));
                }
                catch (Exception e) {
                    IC2.log.warn(LogCategory.Block, e, "Unable to load block model: '%s' for variant: %s", variant.func_188046_a(), personalChestVarient);
                }
            }
        }
        SuddenlyTexture.load((ResourceLocation)ReflectionUtil.getFieldValue(ReflectionUtil.getField(TileEntityPersonalChestRenderer.class, ResourceLocation.class), null), "models/newsafe.png", "personal chest");
    }

    public static SuddenlyTextures fromPosition(ResourceLocation spriteName, String file, final int x, final int y) {
        return new SuddenlyTextures(spriteName, file, 0){

            @Override
            protected BufferedImage getSubImage(ResourceLocation location, BufferedImage image) {
                try {
                    return image.getSubimage(x, y, 16, 16);
                }
                catch (RasterFormatException e) {
                    IC2.log.warn(LogCategory.Resource, e, "Failed to get sub-texture from %s", location.func_110623_a());
                    return null;
                }
            }
        };
    }

    public static SuddenlyTextures asItem(ResourceLocation spriteName, String file) {
        return new SuddenlyTextures(spriteName, "items/" + file, -1);
    }

    public static SuddenlyTextures asBlock(ResourceLocation spriteName, String file, int offset) {
        block15: {
            file = "blocks/" + file;
            try (InputStream input = SuddenlyTextures.getImage(file);){
                int width = new PngSizeInfo((InputStream)input).field_188533_a;
                while (offset * 16 >= width) {
                    offset -= width / 16;
                }
            }
            catch (IOException e) {
                if (!Util.inDev()) break block15;
                throw new RuntimeException(e);
            }
        }
        return new SuddenlyTextures(spriteName, file, offset);
    }

    protected SuddenlyTextures(ResourceLocation spriteName, String file, int offset) {
        this(spriteName, "ic2", file, offset);
    }

    protected SuddenlyTextures(ResourceLocation spriteName, String domain, String file, int offset) {
        super(spriteName.toString());
        this.file = file;
        this.domain = domain;
        this.offset = offset;
    }

    public static ResourceLocation caseSensativeTexture(final String domain, final String file) {
        return new ResourceLocation(""){

            public String func_110624_b() {
                return domain;
            }

            public String func_110623_a() {
                return "textures/" + file;
            }
        };
    }

    protected static InputStream getImage(String file) throws IOException {
        return SuddenlyTextures.getImage("ic2", file);
    }

    protected static InputStream getImage(String domain, String file) throws IOException {
        return PACK.func_110590_a(SuddenlyTextures.caseSensativeTexture(domain, file));
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    protected BufferedImage getSubImage(ResourceLocation location, BufferedImage image) {
        try {
            return image.getSubimage(16 * this.offset, 0, 16, 16);
        }
        catch (RasterFormatException e) {
            if (Util.inDev()) {
                IC2.log.warn(LogCategory.Resource, e, "Failed to get sub-texture from %s", location.func_110623_a());
            }
            return null;
        }
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        BufferedImage subImage;
        BufferedImage image;
        try (InputStream input = SuddenlyTextures.getImage(this.domain, this.file);){
            image = ImageIO.read(input);
        }
        catch (IOException e) {
            if (Util.inDev()) {
                IC2.log.warn(LogCategory.Resource, e, "Failed to load texture from %s", location.func_110623_a());
            }
            return true;
        }
        BufferedImage bufferedImage = subImage = this.offset >= 0 ? this.getSubImage(location, image) : image;
        if (subImage == null) {
            return true;
        }
        if (PACK.func_110589_b(SuddenlyTextures.caseSensativeTexture(this.domain, this.file + ".mcmeta"))) {
            JsonObject json;
            try (InputStream input = SuddenlyTextures.getImage(this.domain, this.file + ".mcmeta");){
                json = new JsonParser().parse((Reader)new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            catch (IOException e) {
                if (Util.inDev()) {
                    IC2.log.warn(LogCategory.Resource, e, "Failed to load texture meta from %s", location.func_110623_a());
                }
                return true;
            }
            IMetadataSection section = ((MetadataSerializer)ReflectionUtil.getValue(manager, MetadataSerializer.class)).func_110503_a("animation", json);
            assert (section instanceof AnimationMetadataSection);
            ReflectionUtil.setValue((Object)this, ANMIATION, section);
            assert (this.func_130098_m());
            this.field_130224_d = subImage.getWidth();
        } else {
            this.field_130224_d = subImage.getHeight();
        }
        this.field_130223_c = subImage.getWidth();
        int[] data = new int[this.field_130224_d * this.field_130223_c];
        subImage.getRGB(0, 0, this.field_130223_c, this.field_130224_d, data, 0, this.field_130223_c);
        int[][] imageData = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
        imageData[0] = data;
        this.field_110976_a.add(imageData);
        return false;
    }

    public void func_147963_d(int level) {
        block23: {
            if (this.func_130098_m()) {
                BufferedImage image;
                AnimationMetadataSection animation = (AnimationMetadataSection)ReflectionUtil.getFieldValue(ANMIATION, (Object)this);
                try (InputStream input = SuddenlyTextures.getImage(this.file);){
                    image = ImageIO.read(input);
                }
                catch (IOException e) {
                    IC2.log.warn(LogCategory.Resource, e, "Failed to load texture for animation");
                    break block23;
                }
                int[][] data = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
                data[0] = new int[image.getWidth() * image.getHeight()];
                image.getRGB(0, 0, image.getWidth(), image.getHeight(), data[0], 0, image.getWidth());
                int maxFrames = image.getHeight() / this.field_130223_c;
                if (animation.func_110473_c() > 0) {
                    Iterator iterator = animation.func_130073_e().iterator();
                    while (iterator.hasNext()) {
                        int frame = (Integer)iterator.next();
                        if (frame >= maxFrames) {
                            throw new RuntimeException("Invalid frameindex: " + frame);
                        }
                        if (this.field_110976_a.size() <= frame) {
                            for (int i = this.field_110976_a.size(); i <= frame; ++i) {
                                this.field_110976_a.add(null);
                            }
                        }
                        this.field_110976_a.set(frame, SuddenlyTextures.getFrameTextureData(data, this.field_130223_c, this.field_130223_c, frame));
                    }
                } else {
                    ArrayList<AnimationFrame> list = new ArrayList<AnimationFrame>(maxFrames);
                    for (int frame = 0; frame < maxFrames; ++frame) {
                        this.field_110976_a.add(SuddenlyTextures.getFrameTextureData(data, this.field_130223_c, this.field_130223_c, frame));
                        list.add(new AnimationFrame(frame, -1));
                    }
                    animation = new AnimationMetadataSection(list, this.field_130223_c, this.field_130224_d, animation.func_110469_d(), animation.func_177219_e());
                    ReflectionUtil.setValue((Object)this, ANMIATION, animation);
                }
            }
        }
        super.func_147963_d(level);
    }

    private static int[][] getFrameTextureData(int[][] image, int rows, int columns, int frame) {
        int[][] textureData = new int[image.length][];
        for (int i = 0; i < image.length; ++i) {
            int[] data = image[i];
            if (data == null) continue;
            textureData[i] = new int[(rows >> i) * (columns >> i)];
            System.arraycopy(data, frame * textureData[i].length, textureData[i], 0, textureData[i].length);
        }
        return textureData;
    }

    static {
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.crafting, CraftingItemType.small_power_unit.getName()), "resources/itempowerunitsmall.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.crafting, CraftingItemType.power_unit.getName()), "resources/itempowerunit.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.upgrade_kit, UpdateKitType.mfsu.getName()), "itemMFSUupgradekit.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.foam_sprayer, null), "itemFoamSprayer.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.wrench, null), "itemToolWrench.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.weeding_trowel, null), "itemWeedingTrowel.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.chainsaw, null), "itemToolChainsaw.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.diamond_drill, null), "itemToolDDrill.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.drill, null), "itemToolDrill.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.electric_hoe, null), "itemToolHoe.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.electric_treetap, null), "itemTreetapElectric.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.electric_wrench, null), "itemToolWrenchElectric.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.iridium_drill, null), "itemToolIridiumDrill.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.mining_laser, null), "itemToolMiningLaser.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.nano_saber, null), "itemNanoSaber.off.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.nano_saber, "active"), "itemNanoSaber.active.png");
        knownItems.put((ResourceLocation)ItemIC2.getModelLocation(ItemName.wind_meter, null), "windmeter.png");
        knownBlocks = new HashMap<String, Map<? extends IIdProvider, String>>();
        EnumMap<ResourceBlock, String> resource = new EnumMap<ResourceBlock, String>(ResourceBlock.class);
        resource.put(ResourceBlock.machine, "machine/blockMachine.png");
        resource.put(ResourceBlock.advanced_machine, "machine/blockAdvMachine.png");
        resource.put(ResourceBlock.reactor_vessel, "reactor/blockreactorvessel.png");
        resource.put(ResourceBlock.uranium_block, "blockMetalUranium.png");
        knownBlocks.put(BlockName.resource.name(), resource);
        knownTeBlocks = new EnumMap<TeBlock, String>(TeBlock.class);
        knownTeBlocks.put(TeBlock.advanced_miner, "machine/blockAdvMiner.png");
        knownTeBlocks.put(TeBlock.blast_furnace, "machine/blockBlastFurnace.png");
        knownTeBlocks.put(TeBlock.block_cutter, "machine/blockBlockCutter.png");
        knownTeBlocks.put(TeBlock.canner, "machine/blockCanner.png");
        knownTeBlocks.put(TeBlock.centrifuge, "machine/blockCentrifuge.png");
        knownTeBlocks.put(TeBlock.compressor, "machine/blockCompressor.png");
        knownTeBlocks.put(TeBlock.condenser, "machine/blockCondenser.png");
        knownTeBlocks.put(TeBlock.crop_harvester, "machine/blockCropHavester.png");
        knownTeBlocks.put(TeBlock.cropmatron, "machine/blockCropmatron.png");
        knownTeBlocks.put(TeBlock.electric_furnace, "machine/blockElecFurnace.png");
        knownTeBlocks.put(TeBlock.electrolyzer, "machine/blockElectrolyzer.png");
        knownTeBlocks.put(TeBlock.extractor, "machine/blockExtractor.png");
        knownTeBlocks.put(TeBlock.fermenter, "machine/blockFermenter.png");
        knownTeBlocks.put(TeBlock.fluid_bottler, "machine/blockFluidBottler.png");
        knownTeBlocks.put(TeBlock.fluid_distributor, "machine/blockFluidDistributor.png");
        knownTeBlocks.put(TeBlock.fluid_regulator, "machine/blockFluidRegulator.png");
        knownTeBlocks.put(TeBlock.induction_furnace, "machine/blockInduction.png");
        knownTeBlocks.put(TeBlock.iron_furnace, "machine/blockIronFurnace.png");
        knownTeBlocks.put(TeBlock.item_buffer, "machine/blockItemBuffer.png");
        knownTeBlocks.put(TeBlock.liquid_heat_exchanger, "machine/blockLiquidHeatExchanger.png");
        knownTeBlocks.put(TeBlock.macerator, "machine/blockMacerator.png");
        knownTeBlocks.put(TeBlock.magnetizer, "machine/blockMagnetizer.png");
        knownTeBlocks.put(TeBlock.mass_fabricator, "machine/blockMatter.png");
        knownTeBlocks.put(TeBlock.matter_generator, "machine/blockMatter.png");
        knownTeBlocks.put(TeBlock.metal_former, "machine/blockMetalFormer.png");
        knownTeBlocks.put(TeBlock.miner, "machine/blockMiner.png");
        knownTeBlocks.put(TeBlock.ore_washing_plant, "machine/blockOreWashingPlant.png");
        knownTeBlocks.put(TeBlock.pattern_storage, "machine/blockPatternStorage.png");
        knownTeBlocks.put(TeBlock.pump, "machine/blockPump.png");
        knownTeBlocks.put(TeBlock.recycler, "machine/blockRecycler.png");
        knownTeBlocks.put(TeBlock.replicator, "machine/blockReplicator.png");
        knownTeBlocks.put(TeBlock.solar_distiller, "machine/blockSolarDestiller.png");
        knownTeBlocks.put(TeBlock.solid_canner, "machine/blockSolidCanner.png");
        knownTeBlocks.put(TeBlock.sorting_machine, "machine/blockSortingMachine.png");
        knownTeBlocks.put(TeBlock.steam_generator, "machine/blockSteamGenerator.png");
        knownTeBlocks.put(TeBlock.teleporter, "machine/blockTeleporter.png");
        knownTeBlocks.put(TeBlock.terraformer, "machine/blockTerra.png");
        knownTeBlocks.put(TeBlock.tesla_coil, "machine/blockTesla.png");
        knownTeBlocks.put(TeBlock.generator, "generator/blockGenerator.png");
        knownTeBlocks.put(TeBlock.geo_generator, "generator/blockGeoGenerator.png");
        knownTeBlocks.put(TeBlock.kinetic_generator, "generator/blockKineticGenerator.png");
        knownTeBlocks.put(TeBlock.nuclear_reactor, "generator/blockNuclearReactor.png");
        knownTeBlocks.put(TeBlock.rt_generator, "generator/blockRTGenerator.png");
        knownTeBlocks.put(TeBlock.semifluid_generator, "generator/blockSemifluidGenerator.png");
        knownTeBlocks.put(TeBlock.solar_generator, "generator/blockSolarGenerator.png");
        knownTeBlocks.put(TeBlock.stirling_generator, "generator/blockStirlingGenerator.png");
        knownTeBlocks.put(TeBlock.water_generator, "generator/blockWaterGenerator.png");
        knownTeBlocks.put(TeBlock.wind_generator, "generator/blockWindGenerator.png");
        knownTeBlocks.put(TeBlock.electric_heat_generator, "heatgenerator/blockElectricHeatGenerator.png");
        knownTeBlocks.put(TeBlock.fluid_heat_generator, "heatgenerator/blockFluidHeatGenerator.png");
        knownTeBlocks.put(TeBlock.rt_heat_generator, "heatgenerator/blockRTHeatGenerator.png");
        knownTeBlocks.put(TeBlock.solid_heat_generator, "heatgenerator/blockSolidHeatGenerator.png");
        knownTeBlocks.put(TeBlock.electric_kinetic_generator, "kineticgenerator/blockElectricKineticGenerator.png");
        knownTeBlocks.put(TeBlock.manual_kinetic_generator, "kineticgenerator/blockManualKineticGenerator.png");
        knownTeBlocks.put(TeBlock.steam_kinetic_generator, "kineticgenerator/blockSteamKineticGenerator.png");
        knownTeBlocks.put(TeBlock.stirling_kinetic_generator, "kineticgenerator/blockStirlingKineticGenerator.png");
        knownTeBlocks.put(TeBlock.water_kinetic_generator, "kineticgenerator/blockWaterKineticGenerator.png");
        knownTeBlocks.put(TeBlock.wind_kinetic_generator, "kineticgenerator/blockWindKineticGenerator.png");
        knownTeBlocks.put(TeBlock.trade_o_mat, "personal/blockPersonalTrader.png");
        knownTeBlocks.put(TeBlock.energy_o_mat, "personal/blockPersonalTraderEnergy.png");
        knownTeBlocks.put(TeBlock.reactor_access_hatch, "reactor/blockReactorAccessHatch.png");
        knownTeBlocks.put(TeBlock.reactor_chamber, "reactor/blockReactorChamber.png");
        knownTeBlocks.put(TeBlock.reactor_fluid_port, "reactor/blockReactorFluidPort.png");
        knownTeBlocks.put(TeBlock.reactor_redstone_port, "reactor/blockReactorRedstonePort.png");
        knownTeBlocks.put(TeBlock.batbox, "wiring/blockBatBox.png");
        knownTeBlocks.put(TeBlock.cesu, "wiring/blockCESU.png");
        knownTeBlocks.put(TeBlock.chargepad_batbox, "wiring/blockChargepadBatBox.png");
        knownTeBlocks.put(TeBlock.chargepad_cesu, "wiring/blockChargepadCESU.png");
        knownTeBlocks.put(TeBlock.chargepad_mfe, "wiring/blockChargepadMFE.png");
        knownTeBlocks.put(TeBlock.chargepad_mfsu, "wiring/blockChargepadMFSU.png");
        knownTeBlocks.put(TeBlock.mfe, "wiring/blockMFE.png");
        knownTeBlocks.put(TeBlock.mfsu, "wiring/blockMFSU.png");
        knownTeBlocks.put(TeBlock.ev_transformer, "wiring/blockTransformerEV.png");
        knownTeBlocks.put(TeBlock.hv_transformer, "wiring/blockTransformerHV.png");
        knownTeBlocks.put(TeBlock.mv_transformer, "wiring/blockTransformerMV.png");
        knownTeBlocks.put(TeBlock.lv_transformer, "wiring/blockTransformerLV.png");
        knownTeBlocks.put(TeBlock.itnt, "blockITNT.png");
        knownTeBlocks.put(TeBlock.nuke, "blockNuke.png");
        ANMIATION = ReflectionUtil.getField(TextureAtlasSprite.class, AnimationMetadataSection.class);
    }

    public static class SuddenlyTexture
    extends AbstractTexture {
        protected final String location;
        protected final String name;

        public static void check(ResourceLocation texture, String location, String name) {
            if (Minecraft.func_71410_x().field_71446_o.func_110581_b(texture) == null) {
                SuddenlyTexture.load(texture, location, name);
            }
        }

        public static boolean load(ResourceLocation texture, String location, String name) {
            return Minecraft.func_71410_x().field_71446_o.func_110579_a(texture, (ITextureObject)new SuddenlyTexture(location, name));
        }

        protected SuddenlyTexture(String location, String name) {
            this.location = location;
            this.name = name;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            this.func_147631_c();
            try (InputStream input = SuddenlyTextures.getImage(this.location);){
                TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)ImageIO.read(input), (boolean)false, (boolean)false);
            }
            catch (IOException e) {
                IC2.log.warn(LogCategory.Resource, e, "Failed to load " + this.name + " texture");
            }
        }
    }
}

