/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.policy;

import ipsis.woot.policy.IPolicy;
import ipsis.woot.util.CompareUtils;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PolicyRepository
implements IPolicy {
    private List<String> internalModBlacklist = new ArrayList<String>();
    private List<WootMobName> internalEntityBlacklist = new ArrayList<WootMobName>();
    private List<String> internalItemModBlacklist = new ArrayList<String>();
    private List<ItemStack> internalItemBlacklist = new ArrayList<ItemStack>();
    private List<String> externalModBlacklist = new ArrayList<String>();
    private List<WootMobName> externalEntityBlacklist = new ArrayList<WootMobName>();
    private List<String> externalItemModBlacklist = new ArrayList<String>();
    private List<ItemStack> externalItemBlacklist = new ArrayList<ItemStack>();
    private List<WootMobName> externalEntityWhitelist = new ArrayList<WootMobName>();

    @Override
    public boolean canCapture(WootMobName wootMobName) {
        for (String mod : this.internalModBlacklist) {
            if (!CompareUtils.isFromMod(wootMobName, mod)) continue;
            return false;
        }
        for (WootMobName name : this.internalEntityBlacklist) {
            if (!CompareUtils.isSameMob(wootMobName, name.getName())) continue;
            return false;
        }
        for (String mod : this.externalModBlacklist) {
            if (!CompareUtils.isFromMod(wootMobName, mod)) continue;
            return false;
        }
        for (WootMobName name : this.externalEntityBlacklist) {
            if (!CompareUtils.isSameMob(wootMobName, name.getName())) continue;
            return false;
        }
        if (!this.externalEntityWhitelist.isEmpty()) {
            for (WootMobName name : this.externalEntityWhitelist) {
                if (!CompareUtils.isSameMob(wootMobName, name.getName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isItemBlacklisted(ItemStack itemStack) {
        for (String modName : this.internalItemModBlacklist) {
            if (!CompareUtils.isFromMod(itemStack, modName)) continue;
            return true;
        }
        for (ItemStack itemStack1 : this.internalItemBlacklist) {
            if (!CompareUtils.isSameItem(itemStack, itemStack1)) continue;
            return true;
        }
        for (String modName : this.externalItemModBlacklist) {
            if (!CompareUtils.isFromMod(itemStack, modName)) continue;
            return true;
        }
        for (ItemStack itemStack1 : this.externalItemBlacklist) {
            if (!CompareUtils.isSameItem(itemStack, itemStack1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canLearnDrop(ItemStack itemStack) {
        return !this.isItemBlacklisted(itemStack);
    }

    @Override
    public boolean canDrop(ItemStack itemStack) {
        return !this.isItemBlacklisted(itemStack);
    }

    @Override
    public void addModToEntityList(String modName, boolean internal) {
        if (internal) {
            this.internalModBlacklist.add(modName);
        } else {
            this.externalModBlacklist.add(modName);
        }
    }

    @Override
    public void addEntityToEntityList(WootMobName wootMobName, boolean internal) {
        if (internal) {
            this.internalEntityBlacklist.add(wootMobName);
        } else {
            this.externalEntityBlacklist.add(wootMobName);
        }
    }

    @Override
    public void addEntityToEntityWhitelist(WootMobName wootMobName) {
        this.externalEntityWhitelist.add(wootMobName);
    }

    @Override
    public void addModToDropList(String modName, boolean internal) {
        if (internal) {
            this.internalItemModBlacklist.add(modName);
        } else {
            this.externalItemModBlacklist.add(modName);
        }
    }

    @Override
    public void addItemToDropList(ItemStack itemStack, boolean internal) {
        if (internal) {
            this.internalItemBlacklist.add(itemStack);
        } else {
            this.externalItemBlacklist.add(itemStack);
        }
    }

    @Override
    public List<String> getEntityList(boolean internal) {
        ArrayList<String> entities = new ArrayList<String>();
        if (internal) {
            entities.addAll(this.internalModBlacklist);
            for (WootMobName wootMobName : this.internalEntityBlacklist) {
                entities.add(wootMobName.getName());
            }
        } else {
            entities.addAll(this.externalModBlacklist);
            for (WootMobName wootMobName : this.externalEntityBlacklist) {
                entities.add(wootMobName.getName());
            }
        }
        return entities;
    }

    @Override
    public List<String> getItemList(boolean internal) {
        ArrayList<String> items = new ArrayList<String>();
        if (internal) {
            items.addAll(this.internalItemModBlacklist);
            for (ItemStack itemStack : this.internalItemBlacklist) {
                items.add(itemStack.func_77977_a());
            }
        } else {
            items.addAll(this.externalItemModBlacklist);
            for (ItemStack itemStack : this.externalItemBlacklist) {
                items.add(itemStack.toString());
            }
        }
        return items;
    }
}

