/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.textures;

import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class AlphaModifiedTexture
extends TextureAtlasSprite {
    final BufferedImage image;

    protected AlphaModifiedTexture(String spriteName, BufferedImage image) {
        super(spriteName);
        this.image = image;
        this.field_130223_c = image.getWidth();
        this.field_130224_d = image.getHeight();
    }

    public static TextureAtlasSprite generate(String name, BufferedImage bi, float alphaMultiplier, TextureMap map) {
        BufferedImage image = new BufferedImage(bi.getWidth(), bi.getHeight(), 6);
        int xx = bi.getWidth();
        int yy = bi.getHeight();
        for (int x = 0; x < xx; ++x) {
            for (int y = 0; y < yy; ++y) {
                int color = bi.getRGB(x, y);
                int a = (int)((float)(color >> 24 & 0xFF) * alphaMultiplier);
                image.setRGB(x, y, color & 0xFFFFFF | a << 24);
            }
        }
        AlphaModifiedTexture out = new AlphaModifiedTexture(name, image);
        out.register(map);
        return out;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        BufferedImage[] images = new BufferedImage[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1];
        images[0] = this.image;
        int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
        pixels[0] = new int[this.image.getWidth() * this.image.getHeight()];
        this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), pixels[0], 0, this.image.getWidth());
        this.field_110976_a.add(pixels);
        return false;
    }

    public void register(TextureMap map) {
        map.setTextureEntry((TextureAtlasSprite)this);
    }
}

