/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileWithTeam
extends TileBase {
    public String team = "";
    public boolean indestructible = false;
    protected ITeamData cTeam;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!this.team.isEmpty()) {
            nbt.func_74778_a("Team", this.team);
        }
        if (this.indestructible) {
            nbt.func_74757_a("Indestructible", true);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.team = nbt.func_74779_i("Team");
        this.indestructible = nbt.func_74767_n("Indestructible");
        this.func_145836_u();
    }

    public void writeToItem(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt, EnumSaveType.ITEM);
        if (!nbt.func_82582_d()) {
            stack.func_77982_d(nbt);
        }
    }

    public void readFromItem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        this.readData(nbt == null ? new NBTTagCompound() : nbt, EnumSaveType.ITEM);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.cTeam = null;
    }

    @Nullable
    public final ITeamData getTeam() {
        if (this.team.isEmpty()) {
            return null;
        }
        if (this.cTeam == null && this.field_145850_b != null) {
            this.cTeam = FTBQuests.PROXY.getQuestFile(this.field_145850_b).getData(this.team);
        }
        return this.cTeam;
    }

    public boolean canBeWrenched(EntityPlayer player) {
        return !this.indestructible;
    }

    public final boolean isOwner(EntityPlayer player) {
        return this.team.isEmpty() || FTBLibAPI.getTeam((UUID)player.func_110124_au()).equals(this.team);
    }

    protected ConfigTeam createTeamConfig() {
        return new ConfigTeam(() -> Universe.get().getTeam(this.team), v -> {
            this.team = v.getID();
            this.cTeam = null;
        });
    }

    public void setIDFromPlacer(EntityLivingBase placer) {
        if (this.team.isEmpty() && placer instanceof EntityPlayerMP) {
            this.team = FTBLibAPI.getTeam((UUID)placer.func_110124_au());
        }
    }
}

