/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;

public class StatTask
extends QuestTask {
    public StatBase stat = StatList.field_188070_B;
    public int value = 1;

    public static StatBase get(String id) {
        for (StatBase base : StatList.field_188094_c) {
            if (!base.field_75975_e.equals(id)) continue;
            return base;
        }
        return StatList.field_188070_B;
    }

    public StatTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.STAT;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return Integer.toString(this.value);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stat", this.stat.field_75975_e);
        nbt.func_74768_a("value", this.value);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stat = StatTask.get(nbt.func_74779_i("stat"));
        this.value = nbt.func_74762_e("value");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stat.field_75975_e);
        data.writeVarInt(this.value);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stat = StatTask.get(data.readString());
        this.value = data.readVarInt();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("stat", () -> this.stat, v -> {
            this.stat = v;
        }, NameMap.create((Object)StatList.field_188070_B, (NameMap.ObjectProperties)NameMap.ObjectProperties.withName((sender, s) -> s.func_150951_e()), (Object[])StatList.field_188094_c.toArray(new StatBase[0])));
        config.addInt("value", () -> this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return StringUtils.color((ITextComponent)this.stat.func_150951_e(), null);
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<StatTask> {
        private Data(StatTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return Integer.toString((int)this.progress);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            if (this.progress >= (long)((StatTask)this.task).value) {
                return false;
            }
            int set = Math.min(((StatTask)this.task).value, player.func_147099_x().func_77444_a(((StatTask)this.task).stat));
            if ((long)set > this.progress) {
                if (!simulate) {
                    this.progress = set;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

