/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandReward
extends QuestReward {
    private String command = "/say Hi, @team!";

    public CommandReward(Quest quest) {
        super(quest);
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.COMMAND;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("command", this.command);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.command = nbt.func_74779_i("command");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.command);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.command = data.readString();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("command", () -> this.command, v -> {
            this.command = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.command", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player) {
        BlockPos pos = player.func_180425_c();
        player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), this.command.replace("@p", player.func_70005_c_()).replace("@x", Integer.toString(pos.func_177958_n())).replace("@y", Integer.toString(pos.func_177956_o())).replace("@z", Integer.toString(pos.func_177952_p())).replace("@chapter", this.quest.chapter.toString()).replace("@quest", this.quest.toString()).replace("@team", FTBLibAPI.getTeam((UUID)player.func_110124_au())));
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentString text = new TextComponentString(this.command);
        text.func_150256_b().func_150238_a(TextFormatting.RED);
        return new TextComponentTranslation("ftbquests.reward.ftbquests.command", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }
}

