/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.loot;

import com.feed_the_beast.ftbquests.quest.reward.QuestReward;

public class WeightedReward
implements Comparable<WeightedReward> {
    public final QuestReward reward;
    public int weight;

    public WeightedReward(QuestReward r, int w) {
        this.reward = r;
        this.weight = Math.max(w, 1);
    }

    public static String chanceString(int weight, int totalWeight) {
        if (totalWeight <= 0) {
            return "??%";
        }
        int chance = weight * 100 / totalWeight;
        if (chance == 0) {
            return String.format("%.2f%%", (double)weight * 100.0 / (double)totalWeight);
        }
        return chance + "%";
    }

    @Override
    public int compareTo(WeightedReward o) {
        return Integer.compare(this.weight, o.weight);
    }
}

