/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.loot;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class EntityWeight {
    public int passive = 0;
    public int monster = 0;
    public int boss = 0;
    public Object2IntOpenHashMap<ResourceLocation> custom = new Object2IntOpenHashMap();

    public EntityWeight() {
        this.custom.defaultReturnValue(-1);
    }

    public int getWeight(Entity entity) {
        int i = this.custom.getInt((Object)EntityList.func_191301_a((Entity)entity));
        if (i >= 0) {
            return i;
        }
        if (!entity.func_184222_aU()) {
            return this.boss;
        }
        if (entity instanceof IMob) {
            return this.monster;
        }
        return this.passive;
    }

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74768_a("#passive", this.passive);
        nbt.func_74768_a("#monster", this.monster);
        nbt.func_74768_a("#boss", this.boss);
        for (Object2IntMap.Entry entry : this.custom.object2IntEntrySet()) {
            nbt.func_74768_a(((ResourceLocation)entry.getKey()).toString(), entry.getIntValue());
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.passive = nbt.func_74762_e("#passive");
        this.monster = nbt.func_74762_e("#monster");
        this.boss = nbt.func_74762_e("#boss");
        this.custom.clear();
        for (String s : nbt.func_150296_c()) {
            if (s.startsWith("#")) continue;
            this.custom.put((Object)new ResourceLocation(s), nbt.func_74762_e(s));
        }
    }

    public void writeNetData(DataOut data) {
        data.writeVarInt(this.passive);
        data.writeVarInt(this.monster);
        data.writeVarInt(this.boss);
        data.writeVarInt(this.custom.size());
        for (Object2IntMap.Entry entry : this.custom.object2IntEntrySet()) {
            data.writeResourceLocation((ResourceLocation)entry.getKey());
            data.writeVarInt(entry.getIntValue());
        }
    }

    public void readNetData(DataIn data) {
        this.passive = data.readVarInt();
        this.monster = data.readVarInt();
        this.boss = data.readVarInt();
        this.custom.clear();
        int s = data.readVarInt();
        for (int i = 0; i < s; ++i) {
            ResourceLocation id = data.readResourceLocation();
            int v = data.readVarInt();
            this.custom.put((Object)id, v);
        }
    }
}

