/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.item;

import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemMissing
extends Item {
    public ItemMissing() {
        this.func_77625_d(1);
    }

    private static ItemStack getContainedStack(ItemStack stack) {
        return stack.func_77942_o() ? ItemStackSerializer.read((NBTBase)stack.func_77978_p().func_74781_a("item")) : ItemStack.field_190927_a;
    }

    public static ItemStack read(@Nullable NBTBase nbt) {
        if (nbt == null || nbt.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStackSerializer.read((NBTBase)nbt);
        if (stack.func_77973_b() == FTBQuestsItems.MISSING) {
            ItemStack stack1 = ItemMissing.getContainedStack(stack);
            if (!stack1.func_190926_b()) {
                return stack1;
            }
        } else if (stack.func_190926_b()) {
            ItemStack stack1 = new ItemStack(FTBQuestsItems.MISSING);
            stack1.func_77983_a("item", nbt.func_74737_b());
            return stack1;
        }
        return stack;
    }

    public static NBTBase write(ItemStack stack, boolean forceCompound) {
        if (stack.func_77973_b() == FTBQuestsItems.MISSING) {
            NBTBase base;
            NBTBase nBTBase = base = stack.func_77942_o() ? stack.func_77978_p().func_74781_a("item") : null;
            if (forceCompound) {
                NBTTagCompound nbt = new NBTTagCompound();
                if (base != null && !base.func_82582_d()) {
                    nbt.func_74782_a("item", base);
                }
                return nbt;
            }
            return base == null || base.func_82582_d() ? new NBTTagString("") : base;
        }
        return ItemStackSerializer.write((ItemStack)stack, (boolean)forceCompound);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!(entity instanceof EntityPlayer) || world.func_82737_E() % 100L != 65L) {
            return;
        }
        ItemStack stack1 = ItemMissing.getContainedStack(stack);
        if (!stack1.func_190926_b()) {
            if (!world.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entity), (ItemStack)stack1, (int)slot);
            }
            stack.func_190918_g(1);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return !ItemMissing.getContainedStack(stack).func_190926_b();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public String func_77653_i(ItemStack stack) {
        ResourceLocation name;
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        NBTBase nbt = stack.func_77978_p().func_74781_a("item");
        if (nbt == null || nbt.func_82582_d()) {
            return super.func_77653_i(stack);
        }
        ItemStack stack1 = ItemStackSerializer.read((NBTBase)nbt);
        int meta = 0;
        int count = 1;
        if (!stack1.func_190926_b()) {
            name = stack1.func_77973_b().getRegistryName();
            count = stack1.func_190916_E();
            meta = stack1.func_77960_j();
        } else {
            NBTTagCompound nbt1;
            if (nbt instanceof NBTTagString) {
                nbt1 = new NBTTagCompound();
                nbt1.func_74782_a("item", nbt);
            } else {
                nbt1 = (NBTTagCompound)nbt;
            }
            if (nbt1.func_150297_b("item", 8)) {
                String[] sa = nbt1.func_74779_i("item").split(" ", 4);
                name = new ResourceLocation(sa[0]);
                if (sa.length >= 2) {
                    count = MathHelper.func_82715_a((String)sa[1], (int)1);
                }
                if (sa.length >= 3) {
                    meta = sa[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)sa[2], (int)0);
                }
            } else {
                name = new ResourceLocation(nbt1.func_74779_i("id"));
                count = nbt1.func_74771_c("Count");
                meta = nbt1.func_74765_d("Damage");
            }
        }
        StringBuilder out = new StringBuilder();
        if (count > 1) {
            out.append(TextFormatting.YELLOW);
            out.append(count);
            out.append(TextFormatting.DARK_GRAY);
            out.append('x');
        }
        out.append(TextFormatting.AQUA);
        out.append(name.func_110624_b());
        out.append(TextFormatting.DARK_GRAY);
        out.append(':');
        out.append(TextFormatting.GOLD);
        out.append(name.func_110623_a());
        if (meta > 0) {
            out.append(TextFormatting.DARK_GRAY);
            out.append('@');
            out.append(TextFormatting.GRAY);
            out.append(meta);
        }
        return out.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74781_a("item") != null) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + super.func_77653_i(stack));
        }
    }
}

