/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.item;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLootCrate
extends Item {
    @Nullable
    public static LootCrate getCrate(@Nullable World world, ItemStack stack) {
        if (stack.func_77942_o()) {
            QuestFile file = FTBQuests.PROXY.getQuestFile(world);
            return file == null ? null : file.getLootCrate(stack.func_77978_p().func_74779_i("type"));
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int size;
        ItemStack stack = player.func_184586_b(hand);
        LootCrate crate = ItemLootCrate.getCrate(world, stack);
        if (crate == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        int n = size = player.func_70093_af() ? stack.func_190916_E() : 1;
        if (!world.field_72995_K) {
            int totalWeight;
            if (crate.table != null && (totalWeight = crate.table.getTotalWeight(true)) > 0) {
                block0: for (int j = 0; j < size * crate.table.lootSize; ++j) {
                    int currentWeight = crate.table.emptyWeight;
                    int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
                    if (currentWeight >= number) continue;
                    for (WeightedReward reward : crate.table.rewards) {
                        if ((currentWeight += reward.weight) < number) continue;
                        reward.reward.claim((EntityPlayerMP)player);
                        continue block0;
                    }
                }
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        } else {
            new GuiRewardNotifications().openGui();
            for (int i = 0; i < 5; ++i) {
                Vec3d vec3d = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-world.field_73012_v.nextFloat()) * 0.6 - 0.3;
                Vec3d vec3d1 = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_72441_c(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
                world.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)this), 0});
            }
        }
        stack.func_190918_g(size);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        LootCrate crate = ItemLootCrate.getCrate(null, stack);
        return crate != null && crate.glow;
    }

    public String func_77653_i(ItemStack stack) {
        LootCrate crate = ItemLootCrate.getCrate(null, stack);
        return crate != null && !crate.itemName.isEmpty() ? crate.itemName : super.func_77653_i(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            QuestFile file = FTBQuests.PROXY.getQuestFile(null);
            boolean hasItem = false;
            if (file != null) {
                for (RewardTable table : file.rewardTables) {
                    if (table.lootCrate == null) continue;
                    hasItem = true;
                    ItemStack stack = new ItemStack((Item)this);
                    stack.func_77983_a("type", (NBTBase)new NBTTagString(table.lootCrate.stringID.isEmpty() ? table.toString() : table.lootCrate.stringID));
                    items.add((Object)stack);
                }
            }
            if (!hasItem) {
                items.add((Object)new ItemStack((Item)this));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        LootCrate crate = ItemLootCrate.getCrate(world, stack);
        if (crate != null) {
            if (crate.itemName.isEmpty()) {
                tooltip.add(crate.table.getDisplayName().func_150254_d());
            }
            crate.table.addMouseOverText(tooltip, true, true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("type")) {
            tooltip.add(stack.func_77978_p().func_74779_i("type"));
        }
    }
}

