/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class ButtonDummyQuest
extends Widget {
    public GuiQuestTree treeGui;
    public final byte x;
    public final byte y;

    public ButtonDummyQuest(Panel panel, byte _x, byte _y) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.x = _x;
        this.y = _y;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questLeft.isMouseOver() || this.treeGui.questRight.isMouseOver() || this.treeGui.patreon.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public boolean mousePressed(MouseButton button) {
        if (!this.isMouseOver()) {
            return false;
        }
        if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (QuestTaskType type : QuestTaskType.getRegistry()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName().func_150254_d(), type.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    Quest quest = new Quest(this.treeGui.selectedChapter);
                    quest.x = this.x;
                    quest.y = this.y;
                    new MessageCreateObject(quest, null).sendToServer();
                    type.getGuiProvider().openCreationGui((IOpenableGui)this, quest, task -> {
                        Quest q = this.treeGui.selectedChapter.getQuestAt(this.x, this.y);
                        QuestTask t = type.provider.create(q);
                        NBTTagCompound nbt = new NBTTagCompound();
                        task.writeData(nbt);
                        t.readData(nbt);
                        NBTTagCompound extra = new NBTTagCompound();
                        extra.func_74778_a("type", type.getTypeForNBT());
                        new MessageCreateObject(t, extra).sendToServer();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
            return true;
        }
        if (button.isLeft() && this.treeGui.movingQuest && this.treeGui.getSelectedQuest() != null && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            new MessageMoveQuest(this.treeGui.getSelectedQuest().id, this.x, this.y).sendToServer();
            this.treeGui.movingQuest = false;
            this.treeGui.selectQuest(null);
            return true;
        }
        this.treeGui.selectQuest(null);
        return false;
    }

    public void addMouseOverText(List<String> list) {
        if (this.treeGui.movingQuest && this.treeGui.getSelectedQuest() != null) {
            list.add(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]));
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (!this.treeGui.file.canEdit()) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int s = this.treeGui.zoom * 3 / 2;
        int sx = x + (w - s) / 2;
        int sy = y + (h - s) / 2;
        if (this.treeGui.getSelectedQuest() != null && this.treeGui.movingQuest) {
            this.treeGui.getSelectedQuest().shape.shape.draw(sx, sy, s, s, Color4I.WHITE.withAlpha(20));
        }
        if (this.isMouseOver()) {
            Color4I.WHITE.withAlpha(30).draw(sx, sy, s, s);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)sx, (float)sy, (float)0.0f);
            GlStateManager.func_179139_a((double)((double)this.treeGui.zoom / 24.0), (double)((double)this.treeGui.zoom / 24.0), (double)1.0);
            theme.drawString("X" + this.x, 2, 2);
            theme.drawString("Y" + this.y, 2, 12);
            GlStateManager.func_179121_F();
        }
    }
}

