/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.chest;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiContainerWrapper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.ScrollBar;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.chest.ButtonClaimAllRewards;
import com.feed_the_beast.ftbquests.gui.chest.ButtonInputSlot;
import com.feed_the_beast.ftbquests.gui.chest.ButtonReward;
import com.feed_the_beast.ftbquests.gui.chest.ButtonTask;
import com.feed_the_beast.ftbquests.gui.chest.ButtonTransferAll;
import com.feed_the_beast.ftbquests.gui.chest.ContainerQuestChest;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class GuiQuestChest
extends GuiBase
implements IContainerListener {
    public static final ImageIcon TEXTURE = new ImageIcon(new ResourceLocation("ftbquests", "textures/gui/chest.png"));
    private static final ImageIcon BACKGROUND = TEXTURE.withUVfromCoords(0, 0, 176, 189, 256, 256);
    private static final ImageIcon SCROLL_BAR = TEXTURE.withUVfromCoords(177, 0, 8, 9, 256, 256);
    public final ContainerQuestChest container;
    private final Panel tasks;
    private final PanelScrollBar scrollBar;
    private final Button transferAll;
    private final Button claimAllRewards;
    private final Button inputSlot;
    private final ButtonReward[] outputSlots;

    public GuiQuestChest(ContainerQuestChest c) {
        this.setSize(176, 189);
        this.container = c;
        c.func_75132_a(this);
        this.tasks = new Panel((Panel)this){

            public void addWidgets() {
                if (ClientQuestFile.existsWithTeam()) {
                    QuestTaskData data;
                    for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                        for (Quest quest : chapter.quests) {
                            for (QuestTask task : quest.tasks) {
                                if (!task.canInsertItem() || (long)(data = ClientQuestFile.INSTANCE.self.getQuestTaskData(task)).getRelativeProgress() != 0L || !((QuestTask)data.task).quest.canStartTasks(ClientQuestFile.INSTANCE.self)) continue;
                                this.add((Widget)new ButtonTask(this, data));
                            }
                        }
                    }
                    for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                        for (Quest quest : chapter.quests) {
                            for (QuestTask task : quest.tasks) {
                                if (!task.canInsertItem() || (long)(data = ClientQuestFile.INSTANCE.self.getQuestTaskData(task)).getRelativeProgress() != 100L) continue;
                                this.add((Widget)new ButtonTask(this, data));
                            }
                        }
                    }
                }
            }

            public void alignWidgets() {
                GuiQuestChest.this.scrollBar.setMaxValue(this.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 1)));
            }
        };
        this.tasks.setPosAndSize(8, 9, 148, 68);
        this.scrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.tasks){

            public int getSliderSize() {
                return this.getMaxValue() <= 0 ? 0 : 9;
            }

            public void drawScrollBar(Theme theme, int x, int y, int w, int h) {
                SCROLL_BAR.draw(x, y, w, h);
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
            }
        };
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setCanAlwaysScrollPlane(true);
        this.scrollBar.setPosAndSize(160, 9, 8, 68);
        this.transferAll = new ButtonTransferAll((Panel)this);
        this.transferAll.setPosAndSize(28, 86, 12, 12);
        this.claimAllRewards = new ButtonClaimAllRewards((Panel)this);
        this.claimAllRewards.setPosAndSize(154, 86, 12, 12);
        this.inputSlot = new ButtonInputSlot((Panel)this);
        this.inputSlot.setPosAndSize(8, 84, 16, 16);
        this.outputSlots = new ButtonReward[6];
        for (int i = 0; i < this.outputSlots.length; ++i) {
            this.outputSlots[i] = new ButtonReward((Panel)this);
            this.outputSlots[i].setPosAndSize(44 + i * 18, 84, 16, 16);
        }
    }

    public void addWidgets() {
        this.add((Widget)this.tasks);
        this.add((Widget)this.scrollBar);
        this.add((Widget)this.transferAll);
        this.add((Widget)this.claimAllRewards);
        this.add((Widget)this.inputSlot);
        for (ButtonReward b : this.outputSlots) {
            this.add((Widget)b);
        }
        this.updateRewards();
    }

    public void updateRewards() {
        for (ButtonReward b : this.outputSlots) {
            b.reward = null;
        }
        if (ClientQuestFile.existsWithTeam()) {
            int index = 0;
            for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                    for (QuestReward reward : quest.rewards) {
                        if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                        this.outputSlots[index].reward = reward;
                        if (++index != 6) continue;
                        return;
                    }
                }
            }
        }
    }

    public GuiScreen getWrapper() {
        return new GuiContainerWrapper((GuiBase)this, (Container)this.container).disableSlotDrawing();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BACKGROUND.draw(x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        if (this.outputSlots != null) {
            this.updateRewards();
        }
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (this.outputSlots != null) {
            this.updateRewards();
        }
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }
}

