/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectResponse;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandChangeTeamRewards
extends CommandBase {
    public String func_71517_b() {
        return "change_team_rewards";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ftbquests.change_team_rewards.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP ? FTBQuests.canEdit((EntityPlayerMP)sender) : super.func_184882_a(server, sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 2) {
            return CommandChangeTeamRewards.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(ServerQuestFile.INSTANCE.chapters.size() + 1);
            list.add("*");
            for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
                list.add(chapter.toString());
            }
            return CommandChangeTeamRewards.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Collection<Object> chapters;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equals("*")) {
            chapters = ServerQuestFile.INSTANCE.chapters;
        } else {
            QuestChapter chapter = ServerQuestFile.INSTANCE.getChapter(ServerQuestFile.INSTANCE.getID(args[0]));
            if (chapter == null) {
                throw FTBLib.error((ICommandSender)sender, (String)"commands.ftbquests.change_team_rewards.invalid_id", (Object[])new Object[]{args[0]});
            }
            chapters = Collections.singleton(chapter);
        }
        boolean value = CommandChangeTeamRewards.func_180527_d((String)args[1]);
        ServerQuestFile.INSTANCE.clearCachedData();
        int r = 0;
        for (QuestChapter questChapter : chapters) {
            for (Quest quest : questChapter.quests) {
                for (QuestReward reward : quest.rewards) {
                    if (reward.team == value) continue;
                    reward.team = value;
                    ++r;
                    new MessageEditObjectResponse(reward).sendToAll();
                }
            }
        }
        ServerQuestFile.INSTANCE.save();
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ftbquests.change_team_rewards.text", new Object[]{r, Boolean.toString(value)}));
    }
}

