/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.events.SidebarButtonCreatedEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.client.RenderProgressScreen;
import com.feed_the_beast.ftbquests.client.RenderTaskScreen;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbquests", value={Side.CLIENT})
public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    public static TextureAtlasSprite inputBlockSprite;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.SCREEN, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.SCREEN.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.PROGRESS_DETECTOR, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.PROGRESS_DETECTOR.getRegistryName(), "normal"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.PROGRESS_SCREEN, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.PROGRESS_SCREEN.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.CHEST, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.CHEST.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.BOOK, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.BOOK.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.XP_VIAL, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.XP_VIAL.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.SCRIPT, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.SCRIPT.getRegistryName(), "inventory"));
        ModelResourceLocation lootCrateModel = new ModelResourceLocation(FTBQuestsItems.LOOTCRATE.getRegistryName(), "#inventory");
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.COMMON_LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.UNCOMMON_LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.RARE_LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.EPIC_LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.LEGENDARY_LOOTCRATE, (int)0, (ModelResourceLocation)lootCrateModel);
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.MISSING, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.MISSING.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileTaskScreenCore.class, (TileEntitySpecialRenderer)new RenderTaskScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileProgressScreenCore.class, (TileEntitySpecialRenderer)new RenderProgressScreen());
    }

    public static void postInit() {
        ItemColors c = Minecraft.func_71410_x().getItemColors();
        c.func_186730_a((stack, tintIndex) -> {
            LootCrate crate = ItemLootCrate.getCrate(null, stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, new Item[]{FTBQuestsItems.LOOTCRATE});
        c.func_186730_a((stack, tintIndex) -> -7169638, new Item[]{FTBQuestsItems.COMMON_LOOTCRATE});
        c.func_186730_a((stack, tintIndex) -> -13129111, new Item[]{FTBQuestsItems.UNCOMMON_LOOTCRATE});
        c.func_186730_a((stack, tintIndex) -> -16739073, new Item[]{FTBQuestsItems.RARE_LOOTCRATE});
        c.func_186730_a((stack, tintIndex) -> -8388353, new Item[]{FTBQuestsItems.EPIC_LOOTCRATE});
        c.func_186730_a((stack, tintIndex) -> -16057, new Item[]{FTBQuestsItems.LEGENDARY_LOOTCRATE});
    }

    @SubscribeEvent
    public static void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (!ClientQuestFile.existsWithTeam()) {
                        return "[!]";
                    }
                    int r = 0;
                    for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                            for (QuestReward reward : quest.rewards) {
                                if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                                ++r;
                            }
                        }
                    }
                    if (r > 0) {
                        return Integer.toString(r);
                    }
                }
                return "";
            });
            event.getButton().setTooltipHandler(list -> {
                if (ClientQuestFile.exists() && !ClientQuestFile.existsWithTeam()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"sidebar_button.ftbquests.quests.no_team", (Object[])new Object[0]));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbquests")) {
            switch (event.getID().func_110623_a()) {
                case "open_gui": {
                    ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        inputBlockSprite = event.getMap().func_174942_a(new ResourceLocation("ftbquests", "blocks/screen_front_input"));
    }
}

