/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftbquests.client.ClientQuestProgress;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    private final Short2ObjectOpenHashMap<ClientQuestProgress> teamData = new Short2ObjectOpenHashMap();
    public ClientQuestProgress self;
    public GuiQuestTree questTreeGui;
    public GuiBase questGui;
    public boolean editingMode;
    public final IntCollection rewards = new IntOpenHashSet();

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    public static boolean existsWithTeam() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self != null;
    }

    public void load(MessageSyncQuests message) {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        INSTANCE = this;
        for (MessageSyncQuests.TeamInst team : message.teamData) {
            int i;
            ClientQuestProgress data = new ClientQuestProgress(team.uid, team.id, team.name);
            for (QuestChapter chapter : this.chapters) {
                for (Quest quest : chapter.quests) {
                    for (QuestTask task : quest.tasks) {
                        data.createTaskData(task);
                    }
                }
            }
            for (i = 0; i < team.taskKeys.length; ++i) {
                QuestTask task = this.getTask(team.taskKeys[i]);
                if (task == null) continue;
                data.getQuestTaskData(task).fromNBT(team.taskValues[i]);
            }
            for (i = 0; i < team.variableKeys.length; ++i) {
                data.variables.put(team.variableKeys[i], team.variableValues[i]);
            }
            this.teamData.put(data.getTeamUID(), (Object)data);
        }
        this.self = message.team == 0 ? null : (ClientQuestProgress)this.teamData.get(message.team);
        this.editingMode = message.editingMode;
        this.rewards.addAll(message.rewards);
        this.refreshGui();
    }

    public boolean canEdit() {
        return this.editingMode;
    }

    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        int scrollX = 0;
        int scrollY = 0;
        int selectedChapter = 0;
        int[] selectedQuests = new int[]{};
        if (this.questTreeGui != null) {
            hasPrev = true;
            zoom = this.questTreeGui.zoom;
            scrollX = this.questTreeGui.quests.getScrollX();
            scrollY = this.questTreeGui.quests.getScrollY();
            selectedChapter = this.questTreeGui.selectedChapter == null ? 0 : this.questTreeGui.selectedChapter.id;
            selectedQuests = new int[this.questTreeGui.selectedQuests.size()];
            int i = 0;
            for (Quest q : this.questTreeGui.selectedQuests) {
                selectedQuests[i] = q.id;
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(GuiQuestTree.class) != null) {
                guiOpen = true;
            }
        }
        this.questTreeGui = new GuiQuestTree(this);
        this.questGui = this.questTreeGui;
        if (hasPrev) {
            this.questTreeGui.zoom = zoom;
            this.questTreeGui.selectChapter(this.getChapter(selectedChapter));
            for (int i : selectedQuests) {
                this.questTreeGui.selectedQuests.add(this.getQuest(i));
            }
            if (guiOpen) {
                this.questTreeGui.openGui();
            }
        }
        this.questTreeGui.refreshWidgets();
        GuiVariables guiVariables = (GuiVariables)((Object)ClientUtils.getCurrentGuiAs(GuiVariables.class));
        if (guiVariables != null) {
            guiVariables.refreshWidgets();
        }
        if (hasPrev) {
            this.questTreeGui.quests.setScrollX(scrollX);
            this.questTreeGui.quests.setScrollY(scrollY);
        }
    }

    public void openQuestGui(EntityPlayer player) {
        if (ClientQuestFile.existsWithTeam()) {
            this.questGui.openGui();
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("ftblib.lang.team.error.no_team", new Object[0]), true);
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    @Nullable
    public ClientQuestProgress getData(short team) {
        return team == 0 ? null : (ClientQuestProgress)this.teamData.get(team);
    }

    public ClientQuestProgress removeData(short team) {
        return (ClientQuestProgress)this.teamData.remove(team);
    }

    public void addData(ClientQuestProgress data) {
        this.teamData.put(data.getTeamUID(), (Object)data);
    }

    @Override
    @Nullable
    public ClientQuestProgress getData(String team) {
        if (team.isEmpty()) {
            return null;
        }
        for (ClientQuestProgress data : this.teamData.values()) {
            if (!team.equals(data.getTeamID())) continue;
            return data;
        }
        return null;
    }

    public Collection<ClientQuestProgress> getAllData() {
        return this.teamData.values();
    }

    @Override
    public void deleteObject(int id) {
        new MessageDeleteObject(id).sendToServer();
    }

    public boolean isRewardClaimed(QuestReward reward) {
        return this.rewards.contains(reward.id);
    }
}

