/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import com.google.common.collect.Lists;
import elec332.core.world.IMultiWorldPositionedObjectHolder;
import elec332.core.world.PositionedObjectHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultMultiWorldPositionedObjectHolder<T>
implements IMultiWorldPositionedObjectHolder<T>,
Supplier<IMultiWorldPositionedObjectHolder<T>> {
    private final List<Consumer<PositionedObjectHolder<T>>> callbacks;
    private final Int2ObjectMap<PositionedObjectHolder<T>> objectsInternal = new Int2ObjectArrayMap();
    private final Map<Integer, PositionedObjectHolder<T>> view = Collections.unmodifiableMap(this.objectsInternal);

    public DefaultMultiWorldPositionedObjectHolder(Consumer<PositionedObjectHolder<T>> callback) {
        this();
        this.callbacks.add(callback);
    }

    public DefaultMultiWorldPositionedObjectHolder() {
        this.callbacks = Lists.newArrayList();
    }

    @Override
    @Nullable
    public PositionedObjectHolder<T> get(int world) {
        return (PositionedObjectHolder)this.objectsInternal.get(world);
    }

    @Override
    @Nonnull
    public PositionedObjectHolder<T> getOrCreate(int world) {
        PositionedObjectHolder<T> ret = this.get(world);
        if (ret == null) {
            ret = this.create();
            for (Consumer<PositionedObjectHolder<PositionedObjectHolder<T>>> consumer : this.callbacks) {
                consumer.accept(ret);
            }
            this.objectsInternal.put(world, ret);
        }
        return ret;
    }

    @Override
    @Nonnull
    public Collection<PositionedObjectHolder<T>> getValues() {
        return this.objectsInternal.values();
    }

    @Override
    @Nonnull
    public Map<Integer, PositionedObjectHolder<T>> getUnModifiableView() {
        return this.view;
    }

    @Override
    public void addCreateCallback(Consumer<PositionedObjectHolder<T>> callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void clear() {
        this.objectsInternal.values().forEach(PositionedObjectHolder::clear);
        this.objectsInternal.clear();
    }

    @Nonnull
    protected PositionedObjectHolder<T> create() {
        return new PositionedObjectHolder();
    }

    @Override
    public IMultiWorldPositionedObjectHolder<T> get() {
        return this;
    }
}

