/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.data.IExternalSaveHandler;
import elec332.core.api.network.INetworkHandler;
import elec332.core.main.ElecCore;
import elec332.core.nbt.NBTMap;
import elec332.core.server.ElecPlayer;
import elec332.core.server.SaveHandler;
import elec332.core.util.IOUtil;
import elec332.core.util.NBTHelper;
import elec332.core.util.PlayerHelper;
import elec332.core.world.WorldHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;
import scala.collection.generic.Clearable;

public final class ServerHelper
implements IExternalSaveHandler {
    public static final ServerHelper instance = new ServerHelper();
    private final Map<String, Class<? extends ElecPlayer.ExtendedProperties>> extendedPropertiesList_;
    private final Map<String, Callable<INBTSerializable>> extendedSaveData_;
    private final Map<String, Class<? extends ElecPlayer.ExtendedProperties>> extendedPropertiesList;
    private final Map<String, Callable<INBTSerializable>> extendedSaveData;
    private NBTHelper generalData;
    private NBTMap<UUID, ElecPlayer> playerData;
    private NBTMap<Integer, NBTHelper> worldData;
    private NBTMap<String, INBTSerializable> savedData;
    private boolean locked;
    private boolean loaded;

    private ServerHelper() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        this.setMaps();
        this.extendedPropertiesList_ = Maps.newHashMap();
        this.extendedPropertiesList = Collections.unmodifiableMap(this.extendedPropertiesList_);
        this.extendedSaveData_ = Maps.newHashMap();
        this.extendedSaveData = Collections.unmodifiableMap(this.extendedSaveData_);
        this.locked = false;
        this.setInvalid();
    }

    private void setMaps() {
        this.playerData = NBTMap.newNBTMap(UUID.class, ElecPlayer.class, new Function<UUID, ElecPlayer>(){

            public ElecPlayer apply(UUID input) {
                ElecPlayer ret = new ElecPlayer(input);
                ret.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                return ret;
            }
        });
        this.worldData = NBTMap.newNBTMap(Integer.class, NBTHelper.class, new NBTHelper.DefaultFunction());
        this.savedData = NBTMap.newNBTMap(String.class, INBTSerializable.class, new Function<String, INBTSerializable>(){

            @Nullable
            public INBTSerializable apply(@Nullable String input) {
                try {
                    return (INBTSerializable)((Callable)ServerHelper.this.extendedSaveData.get(input)).call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void load() {
        SaveHandler.INSTANCE.dummyLoad();
    }

    public void registerExtendedPlayerProperties(String identifier, Class<? extends ElecPlayer.ExtendedProperties> propClass) {
        if (this.extendedPropertiesList_.keySet().contains(identifier)) {
            throw new IllegalArgumentException("Property for " + identifier + " has already been registered!");
        }
        if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) || this.locked) {
            throw new IllegalArgumentException("Mod is attempting to register properties too late: " + identifier + "  " + propClass.getName());
        }
        this.extendedPropertiesList_.put(identifier, propClass);
    }

    @Deprecated
    public void registerExtendedProperties(String s, Callable<INBTSerializable> callable) {
        if (this.extendedSaveData_.containsKey(s)) {
            throw new IllegalArgumentException("Property for " + s + " has already been registered!");
        }
        if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) || this.locked) {
            throw new IllegalArgumentException("Mod is attempting to register properties too late: " + s + "  " + callable.getClass());
        }
        this.extendedSaveData_.put(s, callable);
    }

    public ElecPlayer getPlayer(EntityPlayer player) {
        return this.getPlayer(PlayerHelper.getPlayerUUID(player));
    }

    public ElecPlayer getPlayer(@Nonnull UUID uuid) {
        if (this.isValid()) {
            return (ElecPlayer)this.playerData.get(uuid);
        }
        return null;
    }

    public NBTHelper getPersistentWorldData(World world) {
        return this.getPersistentWorldData(WorldHelper.getDimID(world));
    }

    public NBTHelper getPersistentWorldData(int i) {
        if (!this.isValid()) {
            return null;
        }
        NBTHelper ret = (NBTHelper)this.worldData.get(i);
        if (ret == null) {
            ret = new NBTHelper(new NBTTagCompound());
            this.worldData.put(i, ret);
        }
        return ret;
    }

    public NBTHelper getPersistentGlobalData() {
        if (this.isValid()) {
            return this.generalData;
        }
        return null;
    }

    public <T extends INBTSerializable<NBTTagCompound>> T getExtendedSaveData(Class<T> clazz, String name) {
        return (T)((INBTSerializable)clazz.cast(this.getExtendedSaveData(name)));
    }

    public INBTSerializable getExtendedSaveData(String name) {
        return (INBTSerializable)this.savedData.get(name);
    }

    public List<EntityPlayerMP> getOnlinePlayers() {
        return this.getMinecraftServer().func_184103_al().func_181057_v();
    }

    public boolean isPlayerOnline(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        ElecPlayer player = this.getPlayer(uuid);
        return player != null && this.getPlayer(uuid).isOnline();
    }

    public EntityPlayerMP getRealPlayer(UUID uuid) {
        if (this.isPlayerOnline(uuid)) {
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                if (!PlayerHelper.getPlayerUUID((EntityPlayer)player).equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }

    public List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, BlockPos pos) {
        return this.getAllPlayersWatchingBlock(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, int x, int z) {
        ArrayList ret = Lists.newArrayList();
        if (world instanceof WorldServer) {
            PlayerChunkMap playerManager = ((WorldServer)world).func_184164_w();
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
                if (!playerManager.func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
                ret.add(player);
            }
        }
        return ret;
    }

    public void sendMessageToAllPlayersWatchingBlock(World world, BlockPos pos, IMessage message, INetworkHandler networkHandler) {
        for (EntityPlayerMP player : this.getAllPlayersWatchingBlock(world, pos)) {
            networkHandler.sendTo(message, player);
        }
    }

    public List<EntityPlayerMP> getAllPlayersInDimension(int dimension) {
        ArrayList ret = Lists.newArrayList();
        for (EntityPlayerMP player : this.getOnlinePlayers()) {
            if (WorldHelper.getDimID(player.func_130014_f_()) != dimension) continue;
            ret.add(player);
        }
        return ret;
    }

    public void sendMessageToAllPlayersInDimension(int dimension, IMessage message, INetworkHandler networkHandler) {
        for (EntityPlayerMP playerMP : this.getAllPlayersInDimension(dimension)) {
            networkHandler.sendTo(message, playerMP);
        }
    }

    public MinecraftServer getMinecraftServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public boolean isValid() {
        boolean ret;
        boolean bl = ret = this.getMinecraftServer() != null;
        if (!ret) {
            ElecCore.logger.error("Someone tried to access the server whilst it was in an invalid state!");
        }
        return ret;
    }

    public static boolean isServer(World world) {
        return !world.field_72995_K;
    }

    private void setInvalid() {
        this.generalData = null;
        this.playerData.clear();
        this.worldData.clear();
    }

    private void investigateErrors(boolean errorBefore) {
        if (errorBefore) {
            ElecCore.logger.error("Starting thorough investigation...");
        }
        boolean error = false;
        for (EntityPlayerMP playerMP : this.getOnlinePlayers()) {
            ElecPlayer elecPlayer;
            if (!this.isValid() || (elecPlayer = this.getPlayer((EntityPlayer)playerMP)) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like there is a player online that also never properly connected: " + playerMP.func_70005_c_());
        }
        for (ElecPlayer elecPlayer : this.playerData.values()) {
            EntityPlayerMP online;
            if (!elecPlayer.isOnline() || (online = this.getRealPlayer(elecPlayer.getPlayerUUID())) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like the player with UUID: " + elecPlayer.getPlayerUUID() + " never properly disconnected from the server.");
        }
        if (errorBefore) {
            if (!error) {
                ElecCore.logger.error("No additional errors found...");
            }
            ElecCore.logger.error("Finished investigation.");
        }
    }

    @Override
    public String getName() {
        return "serverData";
    }

    @Override
    public void load(ISaveHandler handler, WorldInfo info, NBTTagCompound tag) {
        File folder;
        if (!this.locked) {
            this.locked = true;
        }
        if ((folder = new File(handler.func_75765_b(), "elec332")).exists()) {
            ElecCore.logger.info("Detected old save system, loading data legacy way...");
            this.loadLegacy(folder);
            try {
                FileUtils.deleteDirectory((File)folder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        this.generalData = new NBTHelper(tag.func_74775_l("generalData"));
        this.setMaps();
        this.playerData.deserializeNBT(tag.func_150295_c("playerData", 10));
        this.worldData.deserializeNBT(tag.func_150295_c("dimData", 10));
        for (Object v : this.savedData.values()) {
            if (!(v instanceof Clearable)) continue;
            ((Clearable)v).clear();
        }
        this.savedData.deserializeNBT(tag.func_150295_c("savedData", 10));
        for (Map.Entry entry : this.extendedSaveData.entrySet()) {
            if (this.savedData.keySet().contains(entry.getKey())) continue;
            try {
                this.savedData.put((String)entry.getKey(), (INBTSerializable)((Callable)entry.getValue()).call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound save(ISaveHandler handler, WorldInfo info) {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74782_a("generalData", (NBTBase)this.generalData.serializeNBT());
        ret.func_74782_a("playerData", (NBTBase)this.playerData.serializeNBT());
        ret.func_74782_a("dimData", (NBTBase)this.worldData.serializeNBT());
        ret.func_74782_a("savedData", (NBTBase)this.savedData.serializeNBT());
        return ret;
    }

    @Override
    public void nullifyData() {
        this.generalData = null;
        this.playerData = null;
        this.worldData = null;
        this.savedData = null;
    }

    private void loadLegacy(File folder) {
        this.generalData = new NBTHelper(IOUtil.NBT.readWithPossibleBackup(new File(folder, "generalData.dat")));
        this.setMaps();
        NBTTagList tagList1 = IOUtil.NBT.readWithPossibleBackup(new File(folder, "playerData.dat")).func_150295_c("playerData", 10);
        this.playerData.deserializeNBT(tagList1);
        NBTTagList tagList2 = IOUtil.NBT.readWithPossibleBackup(new File(folder, "worldData.dat")).func_150295_c("dimData", 10);
        this.worldData.deserializeNBT(tagList2);
        for (Object o : this.savedData.values()) {
            if (!(o instanceof Clearable)) continue;
            ((Clearable)o).clear();
        }
        NBTTagList tagList3 = IOUtil.NBT.readWithPossibleBackup(new File(folder, "savedData.dat")).func_150295_c("savedData", 10);
        this.savedData.deserializeNBT(tagList3);
        for (Map.Entry<String, Callable<INBTSerializable>> entry : this.extendedSaveData.entrySet()) {
            if (this.savedData.keySet().contains(entry.getKey())) continue;
            try {
                this.savedData.put(entry.getKey(), entry.getValue().call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class EventHandler {
        @SubscribeEvent
        public void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            if (!ServerHelper.this.locked) {
                ServerHelper.this.locked = true;
            }
            UUID uuid = PlayerHelper.getPlayerUUID(event.player);
            if (!ServerHelper.this.playerData.keySet().contains(uuid)) {
                ElecPlayer player = new ElecPlayer(uuid);
                player.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                player.deserializeNBT(new NBTTagCompound());
                ServerHelper.this.playerData.put(uuid, player);
            }
            ((ElecPlayer)ServerHelper.this.playerData.get(uuid)).setOnline(true);
        }

        @SubscribeEvent
        public void onPlayerDisconnected(PlayerEvent.PlayerLoggedOutEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            ElecPlayer player = (ElecPlayer)ServerHelper.this.playerData.get(PlayerHelper.getPlayerUUID(event.player));
            if (player == null) {
                ElecCore.logger.error("A player disconnected from the server without connecting first!");
                ElecCore.logger.error("Player: " + event.player.func_145748_c_());
                ServerHelper.this.investigateErrors(true);
                return;
            }
            player.setOnline(false);
        }
    }
}

