/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.java;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public class MapWithDefaultValue<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final Callable<V> c;

    public static <K, V> MapWithDefaultValue<K, V> newMap(Map<K, V> map, Callable<V> newDefaultValueCreator) {
        return new MapWithDefaultValue<K, V>(map, newDefaultValueCreator);
    }

    private MapWithDefaultValue(Map<K, V> map, Callable<V> newDefaultValueCreator) {
        this.map = (Map)Preconditions.checkNotNull(map);
        this.c = (Callable)Preconditions.checkNotNull(newDefaultValueCreator);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V ret = this.map.get(key);
        if (ret == null) {
            try {
                ret = this.c.call();
                this.map.put(key, ret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

