/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.window;

import elec332.core.inventory.window.Window;
import elec332.core.inventory.window.WindowContainer;
import elec332.core.main.ElecCore;
import elec332.core.util.InventoryHelper;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public final class WindowGui
extends GuiContainer {
    private final Window window;

    public WindowGui(EntityPlayer player, Window window) {
        this(new WindowContainer(player, window));
    }

    public WindowGui(WindowContainer container) {
        super((Container)container);
        container.windowContainerHandler.windowGui = this;
        this.window = container.getWindow();
        this.field_146999_f = this.window.xSize;
        this.field_147000_g = this.window.ySize;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.window.width = width;
        this.window.height = height;
        this.window.guiLeft = (width - this.field_146999_f) / 2;
        this.window.guiTop = (height - this.field_147000_g) / 2;
        super.func_146280_a(mc, width, height);
        this.window.initWindow_();
    }

    public void func_183500_a(int w, int h) {
        super.func_183500_a(w, h);
        this.window.width = w;
        this.window.height = h;
        this.window.guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
        this.window.guiTop = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public boolean func_73868_f() {
        return this.window.doesWindowPauseGame();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.window.mouseClicked(mouseX, mouseY, mouseButton)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.window.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        this.window.handleMouseClick(slotIn == null ? null : ((WindowContainer.WidgetLinkedSlot)slotIn).widget, slotId, mouseButton, type);
    }

    void handleMouseClickDefault(Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.window.drawScreenPre(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        this.window.drawScreenPost(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        this.window.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        List<String> list = InventoryHelper.getTooltip(stack, ElecCore.proxy.getClientPlayer(), this.field_146297_k.field_71474_y.field_82882_x);
        this.window.modifyTooltip(list, ((WindowContainer.WidgetLinkedSlot)this.field_147006_u).widget, stack, x, y);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + list.get(i));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        this.window.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179121_F();
    }
}

