/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.compat.forestry.DefaultIndividualDefinition;
import elec332.core.compat.forestry.IGenomeTemplate;
import elec332.core.compat.forestry.IIndividualTemplate;
import elec332.core.main.ElecCore;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import java.util.Set;

public class IndividualDefinitionRegistry {
    static final Set<Class> registeredClasses;
    static final Set<IIndividualTemplate> registeredTemplates;
    static final List<IIndividualTemplate> templates;
    static boolean locked;

    public static <O extends Enum<O>, T extends IGenomeTemplate<S>, S extends IAlleleSpecies, B extends IAlleleSpeciesBuilder> void registerBees(Class<O> clazz) {
        if (!registeredClasses.add(clazz)) {
            throw new IllegalArgumentException("BeeEnum " + clazz.toString() + " has already been registered!");
        }
        for (Enum o : (Enum[])clazz.getEnumConstants()) {
            IndividualDefinitionRegistry.registerBee((IIndividualTemplate)((Object)o));
        }
    }

    public static <T extends IGenomeTemplate<S>, S extends IAlleleSpecies, B extends IAlleleSpeciesBuilder> void registerBee(IIndividualTemplate<T, B, ?, ?, ?, ?> template) {
        IGenomeTemplate genomeTemplate;
        if (locked) {
            throw new IllegalStateException("You cannot register bees in postInit!");
        }
        if (!registeredTemplates.add(template)) {
            throw new IllegalArgumentException("You cannot register a bee twice! Type: " + template.getUid());
        }
        try {
            genomeTemplate = (IGenomeTemplate)template.getGenomeTemplateType().newInstance();
        }
        catch (Exception e) {
            ElecCore.logger.error("Error creating Genome-Template of type: " + template.getGenomeTemplateType().getCanonicalName());
            return;
        }
        template.getIndividualBranch().setBranchProperties(genomeTemplate);
        Object speciesRoot = template.getSpeciesRoot();
        B speciesBuilder = template.getSpeciesBuilder();
        template.getIndividualBranch().setIndividualProperties((IAlleleSpeciesBuilder)speciesBuilder);
        template.setSpeciesProperties(speciesBuilder);
        IAlleleSpecies species = speciesBuilder.build();
        template.modifyGenomeTemplate(genomeTemplate);
        genomeTemplate.setSpecies(species);
        IAllele[] alleles = genomeTemplate.getAlleles();
        speciesRoot.registerTemplate(alleles);
        template.setIndividualDefinition(new DefaultIndividualDefinition(alleles, (ISpeciesRoot)speciesRoot));
        templates.add(template);
    }

    static {
        locked = false;
        templates = Lists.newArrayList();
        registeredClasses = Sets.newHashSet();
        registeredTemplates = Sets.newHashSet();
    }
}

