/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client;

import com.google.common.collect.Maps;
import elec332.core.api.client.ITessellator;
import elec332.core.client.tesselator.ElecTessellator;
import elec332.core.client.tesselator.RenderBlocks;
import elec332.core.main.ElecCore;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    public static final float renderUnit = 0.0625f;
    public static final double BB_EXPAND_NUMBER = (double)0.002f;
    private static final Tessellator mcTessellator = Tessellator.func_178181_a();
    private static final ITessellator tessellator = new ElecTessellator(mcTessellator);
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final RenderBlocks renderBlocks = new RenderBlocks();
    private static final Map<BufferBuilder, ITessellator> worldRenderTessellators = Maps.newHashMap();
    private static final Map<EnumFacing, ITransformation[]> rotateAroundMap;
    private static IBakedModel nullModel;

    @Nonnull
    public static ITessellator forWorldRenderer(BufferBuilder renderer) {
        ITessellator ret = worldRenderTessellators.get(renderer);
        if (ret == null) {
            ret = new ElecTessellator(renderer);
            worldRenderTessellators.put(renderer, ret);
        }
        return ret;
    }

    @Nonnull
    public static RenderBlocks getBlockRenderer() {
        return renderBlocks;
    }

    @Nonnull
    public static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer ret = stack.func_77973_b().getFontRenderer(stack);
        if (ret == null) {
            ret = RenderHelper.getMCFontrenderer();
        }
        return ret;
    }

    @Nonnull
    public static FontRenderer getMCFontrenderer() {
        return RenderHelper.mc.field_71466_p;
    }

    @Nonnull
    public static ITessellator getTessellator() {
        return tessellator;
    }

    @Nonnull
    public static IBakedModel getMissingModel() {
        return Minecraft.func_71410_x().field_175617_aL.func_174951_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends TileEntity> void renderTileEntityAt(TileEntitySpecialRenderer<T> tesr, T tile, double x, double y, double z, float partialTicks, int destroyStage) {
        RenderHelper.renderTileEntityAt(tesr, tile, x, y, z, partialTicks, destroyStage, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends TileEntity> void renderTileEntityAt(TileEntitySpecialRenderer<T> tesr, T tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        tesr.func_192841_a(tile, x, y, x, partialTicks, destroyStage, alpha);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partialTicks, int destroyStage) {
        RenderHelper.renderTileEntityAt(tile, x, y, z, partialTicks, destroyStage, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityRendererDispatcher.field_147556_a.func_192854_a(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    public static void drawExpandedSelectionBoundingBox(@Nonnull AxisAlignedBB aabb) {
        RenderHelper.drawSelectionBoundingBox(RenderHelper.expandAABB(aabb));
    }

    public static void drawSelectionBoundingBox(@Nonnull AxisAlignedBB aabb) {
        RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
    }

    @Nonnull
    public static AxisAlignedBB expandAABB(@Nonnull AxisAlignedBB aabb) {
        return aabb.func_186662_g((double)0.002f);
    }

    @Nonnull
    public static ITransformation getTransformation(int x, int y, int z) {
        if ((z = MathHelper.func_180184_b((int)z, (int)360)) == 0) {
            return ModelRotation.func_177524_a((int)x, (int)y);
        }
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f((float)MathHelper.func_180184_b((int)x, (int)360), (float)MathHelper.func_180184_b((int)y, (int)360), (float)z)), null, null));
    }

    public static ITransformation[] getTranformationsFor(EnumFacing axis) {
        return rotateAroundMap.get(axis);
    }

    @Nonnull
    public static ModelRotation combine(ModelRotation rotation1, ModelRotation rotation2) {
        if (rotation1 == null && rotation2 == null) {
            return ModelRotation.X0_Y0;
        }
        if (rotation1 == null) {
            return rotation2;
        }
        if (rotation2 == null) {
            return rotation1;
        }
        return ModelRotation.func_177524_a((int)((rotation1.field_177543_t + rotation2.field_177543_t) * 90), (int)((rotation1.field_177542_u + rotation2.field_177542_u) * 90));
    }

    @Nonnull
    public static ModelRotation defaultFor(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return ModelRotation.X0_Y90;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y270;
            }
            case UP: {
                return ModelRotation.X270_Y0;
            }
            case DOWN: {
                return ModelRotation.X90_Y0;
            }
        }
        return ModelRotation.X0_Y0;
    }

    @Nonnull
    public static Vec3d getPlayerVec(float partialTicks) {
        EntityPlayer player = ElecCore.proxy.getClientPlayer();
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        return new Vec3d(dX, dY, dZ);
    }

    public static void translateToWorld(float partialTicks) {
        Vec3d vec = RenderHelper.getPlayerVec(partialTicks);
        GlStateManager.func_179137_b((double)(-vec.field_72450_a), (double)(-vec.field_72448_b), (double)(-vec.field_72449_c));
    }

    @Nonnull
    public static Vec3d getPlayerVec() {
        EntityPlayer player = ElecCore.proxy.getClientPlayer();
        return new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    @Nonnull
    public static ICamera getPlayerCamera(float partialTicks) {
        Frustum camera = new Frustum();
        Vec3d vec = RenderHelper.getPlayerVec(partialTicks);
        camera.func_78547_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        return camera;
    }

    public static void drawLine(Vec3d from, Vec3d to, Vec3d player, float thickness) {
        RenderHelper.drawQuad(from, from.func_72441_c((double)thickness, (double)thickness, (double)thickness), to, to.func_72441_c((double)thickness, (double)thickness, (double)thickness));
    }

    public static void drawQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        tessellator.addVertexWithUV(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0, 0.0);
        tessellator.addVertexWithUV(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 1.0, 0.0);
        tessellator.addVertexWithUV(v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 1.0, 1.0);
        tessellator.addVertexWithUV(v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 0.0, 1.0);
    }

    @Nonnull
    public static Vec3d multiply(Vec3d original, double m) {
        return new Vec3d(original.field_72450_a * m, original.field_72448_b * m, original.field_72449_c * m);
    }

    public static void bindBlockTextures() {
        RenderHelper.bindTexture(RenderHelper.getBlocksResourceLocation());
    }

    public static void bindTexture(ResourceLocation rl) {
        RenderHelper.mc.field_71446_o.func_110577_a(rl);
    }

    @Nonnull
    public static TextureAtlasSprite checkIcon(TextureAtlasSprite icon) {
        if (icon == null) {
            return RenderHelper.getMissingTextureIcon();
        }
        return icon;
    }

    @Nonnull
    public static TextureAtlasSprite getFluidTexture(Fluid fluid, boolean flowing) {
        if (fluid == null) {
            return RenderHelper.getMissingTextureIcon();
        }
        return RenderHelper.checkIcon(flowing ? RenderHelper.getIconFrom(fluid.getFlowing()) : RenderHelper.getIconFrom(fluid.getStill()));
    }

    @Nonnull
    public static TextureAtlasSprite getMissingTextureIcon() {
        return mc.func_147117_R().func_174944_f();
    }

    public static TextureAtlasSprite getIconFrom(ResourceLocation rl) {
        return mc.func_147117_R().func_110572_b(rl.toString());
    }

    @Nonnull
    public static ResourceLocation getBlocksResourceLocation() {
        return TextureMap.field_110575_b;
    }

    public void spawnParticle(Particle particle) {
        RenderHelper.mc.field_71452_i.func_78873_a(particle);
    }

    public static void disableStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }

    public static void enableStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
    }

    public static void enableGUIStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    static {
        worldRenderTessellators.put(mcTessellator.func_178180_c(), tessellator);
        rotateAroundMap = Maps.newEnumMap(EnumFacing.class);
        block8: for (EnumFacing facing : EnumFacing.field_82609_l) {
            switch (facing) {
                case NORTH: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(0, 0, 0), RenderHelper.getTransformation(0, 0, 90), RenderHelper.getTransformation(0, 0, 180), RenderHelper.getTransformation(0, 0, 270)});
                    continue block8;
                }
                case EAST: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(0, 90, 0), RenderHelper.getTransformation(180, -90, 90), RenderHelper.getTransformation(-90, -90, 90), RenderHelper.getTransformation(0, -90, 90)});
                    continue block8;
                }
                case SOUTH: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(180, 0, 0), RenderHelper.getTransformation(180, 0, 90), RenderHelper.getTransformation(180, 0, 180), RenderHelper.getTransformation(180, 0, -90)});
                    continue block8;
                }
                case WEST: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(0, 90, 180), RenderHelper.getTransformation(180, 90, 180), RenderHelper.getTransformation(90, 90, 180), RenderHelper.getTransformation(-90, 90, 180)});
                    continue block8;
                }
                case UP: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(-90, 0, 0), RenderHelper.getTransformation(90, 0, 90), RenderHelper.getTransformation(90, 0, 180), RenderHelper.getTransformation(90, 0, -90)});
                    continue block8;
                }
                case DOWN: {
                    rotateAroundMap.put(facing, new ITransformation[]{RenderHelper.getTransformation(90, 0, 0), RenderHelper.getTransformation(-90, 0, 90), RenderHelper.getTransformation(-90, 0, 180), RenderHelper.getTransformation(-90, 0, -90)});
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

