/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.network;

import com.google.common.base.Preconditions;
import elec332.core.api.network.ElecByteBuf;
import elec332.core.api.network.ILocatedPacket;
import elec332.core.api.util.IEntityFilter;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public interface IPacketDispatcher
extends ElecByteBuf.Factory {
    public String getChannelName();

    public void sendToAll(IMessage var1);

    default public void sendTo(IMessage message, IEntityFilter<EntityPlayerMP> playerFilter, MinecraftServer server) {
        for (EntityPlayerMP player : playerFilter.filterEntities(server.func_184103_al().func_181057_v())) {
            this.sendTo(message, player);
        }
    }

    default public void sendTo(IMessage message, List<EntityPlayerMP> players) {
        for (EntityPlayerMP player : players) {
            this.sendTo(message, player);
        }
    }

    public void sendTo(IMessage var1, EntityPlayerMP var2);

    default public <M extends IMessage & ILocatedPacket> void sendToAllAround(M message, World world, double range) {
        this.sendToAllAround(message, ((ILocatedPacket)message).getTargetPoint(world, range));
    }

    default public void sendToAllAround(IMessage message, World world, BlockPos pos, double range) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(((WorldProvider)Preconditions.checkNotNull((Object)world.field_73011_w)).getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), range));
    }

    public void sendToAllAround(IMessage var1, NetworkRegistry.TargetPoint var2);

    public void sendToDimension(IMessage var1, int var2);

    public void sendToServer(IMessage var1);
}

