/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.flux.FluxNetworks;
import sonar.flux.network.PacketGeneralType;

public class PacketGeneral
implements IMessage {
    public PacketGeneralType type;
    public NBTTagCompound packetTag;
    public int dimension;

    public PacketGeneral() {
    }

    public PacketGeneral(PacketGeneralType type, NBTTagCompound packetTag) {
        this.type = type;
        this.packetTag = packetTag;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = PacketGeneralType.values()[buf.readInt()];
        this.dimension = buf.readInt();
        this.packetTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.dimension);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.packetTag);
    }

    public static class Handler
    implements IMessageHandler<PacketGeneral, IMessage> {
        public IMessage onMessage(PacketGeneral message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> FluxNetworks.proxy.scheduleRunnable(() -> {
                IMessage returnedMessage;
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                if (player != null && (returnedMessage = message.type.doPacket(player, message.packetTag)) != null && player instanceof EntityPlayerMP) {
                    FluxNetworks.network.sendTo(returnedMessage, (EntityPlayerMP)player);
                }
            }));
            return null;
        }
    }
}

